/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute;

import com.speedment.runtime.compute.ToByteNullable;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.ExpressionType;
import com.speedment.runtime.compute.expression.Expressions;
import com.speedment.runtime.compute.internal.expression.ComposedUtil;
import com.speedment.runtime.compute.internal.expression.OrElseGetUtil;
import com.speedment.runtime.compute.internal.expression.OrElseThrowUtil;
import com.speedment.runtime.compute.internal.expression.OrElseUtil;
import com.speedment.runtime.compute.trait.HasAbs;
import com.speedment.runtime.compute.trait.HasCompare;
import com.speedment.runtime.compute.trait.HasCompose;
import com.speedment.runtime.compute.trait.HasHash;
import com.speedment.runtime.compute.trait.HasMapIfPresent;
import com.speedment.runtime.compute.trait.HasMapToDoubleIfPresent;
import com.speedment.runtime.compute.trait.HasNegate;
import com.speedment.runtime.compute.trait.HasSign;
import com.speedment.runtime.compute.trait.HasSqrt;
import com.speedment.runtime.compute.trait.ToNullable;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ToIntFunction;

@FunctionalInterface
public interface ToIntNullable<T>
extends Expression<T>,
ToIntFunction<T>,
ToNullable<T, Integer, ToInt<T>>,
HasAbs<ToIntNullable<T>>,
HasSign<ToByteNullable<T>>,
HasSqrt<ToDoubleNullable<T>>,
HasNegate<ToIntNullable<T>>,
HasMapToDoubleIfPresent<T, IntToDoubleFunction>,
HasMapIfPresent<T, IntUnaryOperator, ToIntNullable<T>>,
HasHash<T>,
HasCompare<T>,
HasCompose<T> {
    public static <T> ToIntNullable<T> of(Function<T, Integer> lambda) {
        Objects.requireNonNull(lambda);
        if (lambda instanceof ToIntNullable) {
            return (ToIntNullable)lambda;
        }
        return lambda::apply;
    }

    @Override
    default public ExpressionType expressionType() {
        return ExpressionType.INT_NULLABLE;
    }

    @Override
    default public int applyAsInt(T object) {
        return (Integer)this.apply(object);
    }

    @Override
    default public ToInt<T> orThrow() {
        return OrElseThrowUtil.intOrElseThrow(this);
    }

    @Override
    default public ToInt<T> orElseGet(ToInt<T> getter) {
        return OrElseGetUtil.intOrElseGet(this, getter);
    }

    @Override
    default public ToInt<T> orElse(Integer value) {
        return OrElseUtil.intOrElse(this, value);
    }

    @Override
    default public ToIntNullable<T> abs() {
        return Expressions.absOrNull(this);
    }

    @Override
    default public ToIntNullable<T> negate() {
        return Expressions.negateOrNull(this);
    }

    @Override
    default public ToByteNullable<T> sign() {
        return Expressions.signOrNull(this);
    }

    @Override
    default public ToDoubleNullable<T> sqrt() {
        return Expressions.sqrtOrNull(this);
    }

    @Override
    default public ToDoubleNullable<T> mapToDoubleIfPresent(final IntToDoubleFunction mapper) {
        final ToIntNullable delegate = this;
        return new ToDoubleNullable<T>(){

            @Override
            public Double apply(T object) {
                return delegate.isNull(object) ? null : Double.valueOf(mapper.applyAsDouble(delegate.applyAsInt(object)));
            }

            @Override
            public double applyAsDouble(T object) {
                return mapper.applyAsDouble(delegate.applyAsInt(object));
            }

            @Override
            public ToDouble<T> orElseGet(ToDouble<T> getter) {
                return object -> delegate.isNull(object) ? getter.applyAsDouble(object) : mapper.applyAsDouble(delegate.applyAsInt(object));
            }

            @Override
            public ToDouble<T> orElse(Double value) {
                return object -> delegate.isNull(object) ? value.doubleValue() : mapper.applyAsDouble(delegate.applyAsInt(object));
            }

            @Override
            public boolean isNull(T object) {
                return delegate.isNull(object);
            }

            @Override
            public boolean isNotNull(T object) {
                return delegate.isNotNull(object);
            }
        };
    }

    @Override
    default public ToIntNullable<T> mapIfPresent(final IntUnaryOperator mapper) {
        final ToIntNullable delegate = this;
        return new ToIntNullable<T>(){

            @Override
            public Integer apply(T object) {
                return delegate.isNull(object) ? null : Integer.valueOf(mapper.applyAsInt(delegate.applyAsInt(object)));
            }

            @Override
            public int applyAsInt(T object) {
                return mapper.applyAsInt(delegate.applyAsInt(object));
            }

            @Override
            public ToInt<T> orElseGet(ToInt<T> getter) {
                return object -> delegate.isNull(object) ? getter.applyAsInt(object) : mapper.applyAsInt(delegate.applyAsInt(object));
            }

            @Override
            public ToInt<T> orElse(Integer value) {
                return object -> delegate.isNull(object) ? value.intValue() : mapper.applyAsInt(delegate.applyAsInt(object));
            }

            @Override
            public boolean isNull(T object) {
                return delegate.isNull(object);
            }

            @Override
            public boolean isNotNull(T object) {
                return delegate.isNotNull(object);
            }
        };
    }

    @Override
    default public long hash(T object) {
        return this.isNull(object) ? 0L : (long)this.applyAsInt(object);
    }

    @Override
    default public int compare(T first, T second) {
        if (this.isNull(first)) {
            return this.isNull(second) ? 0 : 1;
        }
        if (this.isNull(second)) {
            return -1;
        }
        return Integer.compare(this.applyAsInt(first), this.applyAsInt(second));
    }

    @Override
    default public <V> ToIntNullable<V> compose(Function<? super V, ? extends T> before) {
        Function<? super V, ? extends T> casted = before;
        return ComposedUtil.composeToIntNullable(casted, this);
    }
}

