/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute;

import com.speedment.common.function.ToCharFunction;
import com.speedment.runtime.compute.ToChar;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.ExpressionType;
import com.speedment.runtime.compute.internal.expression.ComposedUtil;
import com.speedment.runtime.compute.internal.expression.OrElseGetUtil;
import com.speedment.runtime.compute.internal.expression.OrElseThrowUtil;
import com.speedment.runtime.compute.internal.expression.OrElseUtil;
import com.speedment.runtime.compute.trait.HasCompare;
import com.speedment.runtime.compute.trait.HasCompose;
import com.speedment.runtime.compute.trait.HasHash;
import com.speedment.runtime.compute.trait.ToNullable;
import java.util.function.Function;

@FunctionalInterface
public interface ToCharNullable<T>
extends Expression<T>,
ToCharFunction<T>,
ToNullable<T, Character, ToChar<T>>,
HasHash<T>,
HasCompare<T>,
HasCompose<T> {
    public static <T> ToCharNullable<T> of(Function<T, Character> lambda) {
        if (lambda instanceof ToCharNullable) {
            return (ToCharNullable)lambda;
        }
        return lambda::apply;
    }

    @Override
    default public ExpressionType expressionType() {
        return ExpressionType.CHAR_NULLABLE;
    }

    default public char applyAsChar(T object) {
        return ((Character)this.apply(object)).charValue();
    }

    @Override
    default public ToChar<T> orThrow() {
        return OrElseThrowUtil.charOrElseThrow(this);
    }

    @Override
    default public ToChar<T> orElseGet(ToChar<T> getter) {
        return OrElseGetUtil.charOrElseGet(this, getter);
    }

    @Override
    default public ToChar<T> orElse(Character value) {
        return OrElseUtil.charOrElse(this, value.charValue());
    }

    @Override
    default public long hash(T object) {
        return this.isNull(object) ? 0L : (long)this.applyAsChar(object);
    }

    @Override
    default public int compare(T first, T second) {
        if (this.isNull(first)) {
            return this.isNull(second) ? 0 : 1;
        }
        if (this.isNull(second)) {
            return -1;
        }
        return Character.compare(this.applyAsChar(first), this.applyAsChar(second));
    }

    @Override
    default public <V> ToCharNullable<V> compose(Function<? super V, ? extends T> before) {
        Function<? super V, ? extends T> casted = before;
        return ComposedUtil.composeToCharNullable(casted, this);
    }
}

