/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute;

import com.speedment.common.function.BooleanToDoubleFunction;
import com.speedment.common.function.BooleanUnaryOperator;
import com.speedment.common.function.ToBooleanFunction;
import com.speedment.runtime.compute.ToBooleanNullable;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.ExpressionType;
import com.speedment.runtime.compute.internal.expression.CastUtil;
import com.speedment.runtime.compute.internal.expression.ComposedUtil;
import com.speedment.runtime.compute.internal.expression.MapperUtil;
import com.speedment.runtime.compute.trait.HasAsDouble;
import com.speedment.runtime.compute.trait.HasAsInt;
import com.speedment.runtime.compute.trait.HasAsLong;
import com.speedment.runtime.compute.trait.HasCompare;
import com.speedment.runtime.compute.trait.HasCompose;
import com.speedment.runtime.compute.trait.HasHash;
import com.speedment.runtime.compute.trait.HasMap;
import com.speedment.runtime.compute.trait.HasMapToDouble;
import java.util.function.Function;
import java.util.function.Predicate;

@FunctionalInterface
public interface ToBoolean<T>
extends Expression<T>,
ToBooleanFunction<T>,
HasAsDouble<T>,
HasAsInt<T>,
HasAsLong<T>,
HasMap<T, BooleanUnaryOperator, ToBoolean<T>>,
HasMapToDouble<T, BooleanToDoubleFunction>,
HasHash<T>,
HasCompare<T>,
HasCompose<T> {
    public static <T> ToBoolean<T> of(Predicate<T> lambda) {
        if (lambda instanceof ToBoolean) {
            return (ToBoolean)((Object)lambda);
        }
        return lambda::test;
    }

    public boolean applyAsBoolean(T var1);

    @Override
    default public ExpressionType expressionType() {
        return ExpressionType.BOOLEAN;
    }

    @Override
    default public ToDouble<T> asDouble() {
        return CastUtil.castBooleanToDouble(this);
    }

    @Override
    default public ToInt<T> asInt() {
        return CastUtil.castBooleanToInt(this);
    }

    @Override
    default public ToLong<T> asLong() {
        return CastUtil.castBooleanToLong(this);
    }

    @Override
    default public ToDouble<T> mapToDouble(BooleanToDoubleFunction operator) {
        return MapperUtil.mapBooleanToDouble(this, operator);
    }

    @Override
    default public ToBoolean<T> map(BooleanUnaryOperator operator) {
        return MapperUtil.mapBoolean(this, operator);
    }

    @Override
    default public long hash(T object) {
        return this.applyAsBoolean(object) ? 1L : 0L;
    }

    @Override
    default public int compare(T first, T second) {
        boolean f = this.applyAsBoolean(first);
        boolean s = this.applyAsBoolean(second);
        return Boolean.compare(f, s);
    }

    @Override
    default public <V> ToBoolean<V> compose(Function<? super V, ? extends T> before) {
        Function<? super V, ? extends T> casted = before;
        return ComposedUtil.composeToBoolean(casted, this);
    }

    default public <V> ToBooleanNullable<V> composeNullable(Function<? super V, ? extends T> before) {
        Function<? super V, ? extends T> casted = before;
        return ComposedUtil.composeToBooleanAsNullable(casted, this);
    }
}

