/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.termopmodifier.standard.internal;

import com.speedment.jpastreamer.field.predicate.SpeedmentPredicate;
import com.speedment.jpastreamer.pipeline.Pipeline;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperationFactory;
import com.speedment.jpastreamer.pipeline.terminal.TerminalOperation;
import com.speedment.jpastreamer.pipeline.terminal.TerminalOperationFactory;
import com.speedment.jpastreamer.pipeline.terminal.TerminalOperationType;
import com.speedment.jpastreamer.rootfactory.RootFactory;
import com.speedment.jpastreamer.termopmodifier.TerminalOperationModifier;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Predicate;

final class StandardTerminalOperatorModifier
implements TerminalOperationModifier {
    private final IntermediateOperationFactory intermediateOperationFactory = (IntermediateOperationFactory)RootFactory.getOrThrow(IntermediateOperationFactory.class, ServiceLoader::load);
    private final TerminalOperationFactory terminalOperationFactory = (TerminalOperationFactory)RootFactory.getOrThrow(TerminalOperationFactory.class, ServiceLoader::load);

    StandardTerminalOperatorModifier() {
    }

    public <T> Pipeline<T> modify(Pipeline<T> pipeline) {
        Objects.requireNonNull(pipeline);
        TerminalOperationType terminalOperationType = (TerminalOperationType)pipeline.terminatingOperation().type();
        switch (terminalOperationType) {
            case ANY_MATCH: {
                return this.modifyAnyMatch(pipeline);
            }
            case NONE_MATCH: {
                return this.modifyNoneMatch(pipeline);
            }
            case FIND_FIRST: {
                return this.modifyFindFirst(pipeline);
            }
            case FIND_ANY: {
                return this.modifyFindAny(pipeline);
            }
        }
        return pipeline;
    }

    private <T> Pipeline<T> modifyAnyMatch(Pipeline<T> pipeline) {
        this.getPredicate(pipeline.terminatingOperation()).ifPresent(speedmentPredicate -> {
            pipeline.intermediateOperations().add(this.intermediateOperationFactory.createFilter((Predicate)speedmentPredicate));
            pipeline.intermediateOperations().add(this.intermediateOperationFactory.createLimit(1L));
            pipeline.terminatingOperation(this.terminalOperationFactory.createAnyMatch(p -> true));
        });
        return pipeline;
    }

    private <T> Pipeline<T> modifyNoneMatch(Pipeline<T> pipeline) {
        this.getPredicate(pipeline.terminatingOperation()).ifPresent(speedmentPredicate -> {
            pipeline.intermediateOperations().add(this.intermediateOperationFactory.createFilter((Predicate)speedmentPredicate));
            pipeline.intermediateOperations().add(this.intermediateOperationFactory.createLimit(1L));
            pipeline.terminatingOperation(this.terminalOperationFactory.createNoneMatch(e -> true));
        });
        return pipeline;
    }

    private <T> Pipeline<T> modifyFindFirst(Pipeline<T> pipeline) {
        pipeline.intermediateOperations().add(this.intermediateOperationFactory.createLimit(1L));
        return pipeline;
    }

    private <T> Pipeline<T> modifyFindAny(Pipeline<T> pipeline) {
        pipeline.ordered(false);
        pipeline.intermediateOperations().add(this.intermediateOperationFactory.createLimit(1L));
        return pipeline;
    }

    private <T> Optional<SpeedmentPredicate<T>> getPredicate(TerminalOperation<?, ?> operation) {
        Object[] arguments = operation.arguments();
        if (arguments.length != 1) {
            return Optional.empty();
        }
        if (arguments[0] instanceof SpeedmentPredicate) {
            return Optional.of((SpeedmentPredicate)arguments[0]);
        }
        return Optional.empty();
    }
}

