/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.rootfactory.internal;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class InternalRootFactory {
    public static final String PROVIDER = "Provider ";

    private InternalRootFactory() {
    }

    public static <S> Optional<S> get(Class<S> service, Function<Class<S>, ServiceLoader<S>> loader) {
        Objects.requireNonNull(service);
        Objects.requireNonNull(loader);
        return Optional.ofNullable(InternalRootFactory.getHelper(service, loader));
    }

    public static <S> S getOrThrow(Class<S> service, Function<Class<S>, ServiceLoader<S>> loader) {
        Objects.requireNonNull(service);
        Objects.requireNonNull(loader);
        S selectedService = InternalRootFactory.getHelper(service, loader);
        if (selectedService == null) {
            throw new NoSuchElementException("Unable to get the service " + service.getName());
        }
        return selectedService;
    }

    public static <S> Stream<S> stream(Class<S> service, Function<Class<S>, ServiceLoader<S>> loader) {
        Objects.requireNonNull(service);
        Objects.requireNonNull(loader);
        Iterator<S> iterator = loader.apply(service).iterator();
        if (iterator.hasNext()) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 256), false);
        }
        try {
            S s = InternalRootFactory.getStandard(service);
            return Stream.of(s);
        }
        catch (NoSuchElementException | ServiceConfigurationError e) {
            return Stream.empty();
        }
    }

    private static <S> S getHelper(Class<S> service, Function<Class<S>, ServiceLoader<S>> loader) {
        Iterator<S> iterator = loader.apply(service).iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return InternalRootFactory.getStandard(service);
    }

    private static <S> S getStandard(Class<S> service) {
        String standardServiceName = service.getPackage().getName() + ".standard.Standard" + service.getSimpleName();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(standardServiceName);
        }
        catch (ClassNotFoundException x) {
            InternalRootFactory.fail(service, PROVIDER + standardServiceName + " not found", x);
        }
        if (!service.isAssignableFrom(clazz)) {
            InternalRootFactory.fail(service, PROVIDER + standardServiceName + " not a subtype");
        }
        try {
            Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            S p = service.cast(instance);
            System.out.println("Warning: " + service + " implementation guessed to be " + instance.getClass().getName() + ". This should be fixed to ensure performance and stability.");
            return p;
        }
        catch (Exception x) {
            InternalRootFactory.fail(service, PROVIDER + standardServiceName + " could not be instantiated", x);
            throw new NoSuchElementException("Error");
        }
    }

    private static void fail(Class<?> service, String msg, Throwable cause) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg, cause);
    }

    private static void fail(Class<?> service, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg);
    }
}

