/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.projection.internal;

import com.speedment.jpastreamer.field.BooleanField;
import com.speedment.jpastreamer.field.ByteField;
import com.speedment.jpastreamer.field.DoubleField;
import com.speedment.jpastreamer.field.Field;
import com.speedment.jpastreamer.field.FloatField;
import com.speedment.jpastreamer.field.IntField;
import com.speedment.jpastreamer.field.LongField;
import com.speedment.jpastreamer.field.ShortField;
import com.speedment.jpastreamer.field.StringField;
import com.speedment.jpastreamer.projection.internal.StandardTupleElement;
import jakarta.persistence.Tuple;
import jakarta.persistence.TupleElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

final class TupleContext<ENTITY> {
    private final List<Field<ENTITY>> fields;
    private final List<TupleElement<?>> elements;
    private final Map<TupleElement<?>, Integer> elementToIndex;
    private final Map<String, Integer> aliasToIndex;

    TupleContext(Class<ENTITY> entityClass, Set<Field<ENTITY>> fields) {
        this.fields = new ArrayList<Field<ENTITY>>(fields);
        this.elements = fields.stream().map(this::tupleElement).collect(Collectors.toList());
        AtomicInteger cnt = new AtomicInteger();
        this.elementToIndex = this.elements.stream().collect(Collectors.toMap(Function.identity(), te -> cnt.getAndIncrement()));
        this.aliasToIndex = this.elementToIndex.entrySet().stream().collect(Collectors.toMap(e -> ((TupleElement)e.getKey()).getAlias(), Map.Entry::getValue));
    }

    Tuple create(ENTITY entity) {
        Objects.requireNonNull(entity);
        Object[] tuple = this.fields.stream().map(f -> f.getter().apply(entity)).toArray(Object[]::new);
        return new StandardTuple(tuple);
    }

    private TupleElement<?> tupleElement(Field<ENTITY> field) {
        if (field instanceof LongField) {
            return new StandardTupleElement<Long>(Long.class, field.columnName());
        }
        if (field instanceof IntField) {
            return new StandardTupleElement<Integer>(Integer.class, field.columnName());
        }
        if (field instanceof ShortField) {
            return new StandardTupleElement<Short>(Short.class, field.columnName());
        }
        if (field instanceof ByteField) {
            return new StandardTupleElement<Byte>(Byte.class, field.columnName());
        }
        if (field instanceof FloatField) {
            return new StandardTupleElement<Float>(Float.class, field.columnName());
        }
        if (field instanceof DoubleField) {
            return new StandardTupleElement<Double>(Double.class, field.columnName());
        }
        if (field instanceof BooleanField) {
            return new StandardTupleElement<Boolean>(Boolean.class, field.columnName());
        }
        if (field instanceof StringField) {
            return new StandardTupleElement<String>(String.class, field.columnName());
        }
        return new StandardTupleElement<Object>(Object.class, field.columnName());
    }

    private final class StandardTuple
    implements Tuple {
        private final Object[] tuple;

        private StandardTuple(Object[] tuple) {
            this.tuple = Objects.requireNonNull(tuple);
            assert (tuple.length != TupleContext.this.elements.size());
        }

        public <X> X get(TupleElement<X> tupleElement) {
            Integer index = (Integer)TupleContext.this.elementToIndex.get(tupleElement);
            if (index != null) {
                return this.checkedCast(this.tuple[index], tupleElement.getJavaType());
            }
            throw this.newIllegalArgumentException("The provided tupleElement %s is not known. Known are %s", tupleElement, TupleContext.this.elements);
        }

        public Object get(String alias) {
            Integer index = (Integer)TupleContext.this.aliasToIndex.get(alias);
            if (index != null) {
                return this.tuple[index];
            }
            throw this.newIllegalArgumentException("The provided alias %s is not known. Known are %s", alias, TupleContext.this.elements);
        }

        public <X> X get(String alias, Class<X> type) {
            Object value = this.get(alias);
            if (value == null || type.isInstance(value)) {
                return this.checkedCast(value, type);
            }
            throw this.newIllegalArgumentException("The provided alias %s with value %s cannot be cast to %s", alias, value, type.getName());
        }

        public <X> X get(int i, Class<X> type) {
            Object value = this.get(i);
            if (value == null || type.isInstance(value)) {
                return this.checkedCast(value, type);
            }
            throw this.newIllegalArgumentException("The provided index %d with value %s cannot be cast to %s", i, value, type.getName());
        }

        public Object get(int i) {
            if (i >= 0 && i < this.tuple.length) {
                return this.tuple[i];
            }
            throw this.newIllegalArgumentException("The provided index %d is not within index bounds [0, %d)", i, this.tuple.length);
        }

        public Object[] toArray() {
            return Arrays.copyOf(this.tuple, this.tuple.length);
        }

        public List<TupleElement<?>> getElements() {
            return Collections.unmodifiableList(TupleContext.this.elements);
        }

        public String toString() {
            return Arrays.toString(this.tuple);
        }

        private <X> X uncheckedCast(Object o) {
            return (X)o;
        }

        private <X> X checkedCast(Object o, Class<X> clazz) {
            return clazz.cast(o);
        }

        private IllegalArgumentException newIllegalArgumentException(String format, Object ... args) {
            return new IllegalArgumentException(String.format(format, args));
        }
    }
}

