/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.javanine.internal;

import com.speedment.jpastreamer.exception.JPAStreamerException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class InternalJava9StreamUtil {
    private static final String TAKE_WHILE = "takeWhile";
    private static final String DROP_WHILE = "dropWhile";
    private static final String FILTER = "filter";
    private static final MethodType DOUBLE_METHOD_TYPE = MethodType.methodType(DoubleStream.class, DoublePredicate.class);
    private static final MethodHandle DOUBLE_TAKE_WHILE_METHOD_HANDLE = InternalJava9StreamUtil.createMethodHandle("takeWhile", DoubleStream.class, DOUBLE_METHOD_TYPE);
    private static final MethodHandle DOUBLE_DROP_WHILE_METHOD_HANDLE = InternalJava9StreamUtil.createMethodHandle("dropWhile", DoubleStream.class, DOUBLE_METHOD_TYPE);
    static final MethodHandle DOUBLE_FILTER_METHOD_HANDLE = InternalJava9StreamUtil.createMethodHandle("filter", DoubleStream.class, DOUBLE_METHOD_TYPE);
    private static final MethodType INT_METHOD_TYPE = MethodType.methodType(IntStream.class, IntPredicate.class);
    private static final MethodHandle INT_TAKE_WHILE_METHOD_HANDLE = InternalJava9StreamUtil.createMethodHandle("takeWhile", IntStream.class, INT_METHOD_TYPE);
    private static final MethodHandle INT_DROP_WHILE_METHOD_HANDLE = InternalJava9StreamUtil.createMethodHandle("dropWhile", IntStream.class, INT_METHOD_TYPE);
    static final MethodHandle INT_FILTER_METHOD_HANDLE = InternalJava9StreamUtil.createMethodHandle("filter", IntStream.class, INT_METHOD_TYPE);
    private static final MethodType LONG_METHOD_TYPE = MethodType.methodType(LongStream.class, LongPredicate.class);
    private static final MethodHandle LONG_TAKE_WHILE_METHOD_HANDLE = InternalJava9StreamUtil.createMethodHandle("takeWhile", LongStream.class, LONG_METHOD_TYPE);
    private static final MethodHandle LONG_DROP_WHILE_METHOD_HANDLE = InternalJava9StreamUtil.createMethodHandle("dropWhile", LongStream.class, LONG_METHOD_TYPE);
    static final MethodHandle LONG_FILTER_METHOD_HANDLE = InternalJava9StreamUtil.createMethodHandle("filter", LongStream.class, LONG_METHOD_TYPE);
    private static final MethodType METHOD_TYPE = MethodType.methodType(Stream.class, Predicate.class);
    private static final MethodHandle TAKE_WHILE_METHOD_HANDLE = InternalJava9StreamUtil.createMethodHandle("takeWhile", Stream.class, METHOD_TYPE);
    private static final MethodHandle DROP_WHILE_METHOD_HANDLE = InternalJava9StreamUtil.createMethodHandle("dropWhile", Stream.class, METHOD_TYPE);
    static final MethodHandle FILTER_METHOD_HANDLE = InternalJava9StreamUtil.createMethodHandle("filter", Stream.class, METHOD_TYPE);

    private InternalJava9StreamUtil() {
    }

    public static DoubleStream takeWhile(DoubleStream stream, DoublePredicate predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        if (DOUBLE_TAKE_WHILE_METHOD_HANDLE == null) {
            throw InternalJava9StreamUtil.newUnsupportedOperationException(TAKE_WHILE);
        }
        try {
            Object obj = DOUBLE_TAKE_WHILE_METHOD_HANDLE.invoke(stream, predicate);
            return (DoubleStream)obj;
        }
        catch (Throwable t) {
            throw new JPAStreamerException(t);
        }
    }

    public static DoubleStream dropWhile(DoubleStream stream, DoublePredicate predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        if (DOUBLE_DROP_WHILE_METHOD_HANDLE == null) {
            throw InternalJava9StreamUtil.newUnsupportedOperationException(DROP_WHILE);
        }
        try {
            Object obj = DOUBLE_DROP_WHILE_METHOD_HANDLE.invoke(stream, predicate);
            return (DoubleStream)obj;
        }
        catch (Throwable t) {
            throw new JPAStreamerException(t);
        }
    }

    static DoubleStream filter(DoubleStream stream, DoublePredicate predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        try {
            return DOUBLE_FILTER_METHOD_HANDLE.invoke(stream, predicate);
        }
        catch (Throwable t) {
            throw new JPAStreamerException(t);
        }
    }

    public static IntStream takeWhile(IntStream stream, IntPredicate predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        if (INT_TAKE_WHILE_METHOD_HANDLE == null) {
            throw InternalJava9StreamUtil.newUnsupportedOperationException(TAKE_WHILE);
        }
        try {
            Object obj = INT_TAKE_WHILE_METHOD_HANDLE.invoke(stream, predicate);
            return (IntStream)obj;
        }
        catch (Throwable t) {
            throw new JPAStreamerException(t);
        }
    }

    public static IntStream dropWhile(IntStream stream, IntPredicate predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        if (INT_DROP_WHILE_METHOD_HANDLE == null) {
            throw InternalJava9StreamUtil.newUnsupportedOperationException(DROP_WHILE);
        }
        try {
            Object obj = INT_DROP_WHILE_METHOD_HANDLE.invoke(stream, predicate);
            return (IntStream)obj;
        }
        catch (Throwable t) {
            throw new JPAStreamerException(t);
        }
    }

    static IntStream filter(IntStream stream, IntPredicate predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        try {
            return INT_FILTER_METHOD_HANDLE.invoke(stream, predicate);
        }
        catch (Throwable t) {
            throw new JPAStreamerException(t);
        }
    }

    public static LongStream takeWhile(LongStream stream, LongPredicate predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        if (LONG_TAKE_WHILE_METHOD_HANDLE == null) {
            throw InternalJava9StreamUtil.newUnsupportedOperationException(TAKE_WHILE);
        }
        try {
            Object obj = LONG_TAKE_WHILE_METHOD_HANDLE.invoke(stream, predicate);
            return (LongStream)obj;
        }
        catch (Throwable t) {
            throw new JPAStreamerException(t);
        }
    }

    public static LongStream dropWhile(LongStream stream, LongPredicate predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        if (LONG_DROP_WHILE_METHOD_HANDLE == null) {
            throw InternalJava9StreamUtil.newUnsupportedOperationException(DROP_WHILE);
        }
        try {
            Object obj = LONG_DROP_WHILE_METHOD_HANDLE.invoke(stream, predicate);
            return (LongStream)obj;
        }
        catch (Throwable t) {
            throw new JPAStreamerException(t);
        }
    }

    static LongStream filter(LongStream stream, LongPredicate predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        try {
            return LONG_FILTER_METHOD_HANDLE.invoke(stream, predicate);
        }
        catch (Throwable t) {
            throw new JPAStreamerException(t);
        }
    }

    public static <T> Stream<T> takeWhile(Stream<T> stream, Predicate<? super T> predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        if (TAKE_WHILE_METHOD_HANDLE == null) {
            throw InternalJava9StreamUtil.newUnsupportedOperationException(TAKE_WHILE);
        }
        try {
            Object obj = TAKE_WHILE_METHOD_HANDLE.invoke(stream, predicate);
            return (Stream)obj;
        }
        catch (Throwable t) {
            throw new JPAStreamerException(t);
        }
    }

    public static <T> Stream<T> dropWhile(Stream<T> stream, Predicate<? super T> predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        if (DROP_WHILE_METHOD_HANDLE == null) {
            throw InternalJava9StreamUtil.newUnsupportedOperationException(DROP_WHILE);
        }
        try {
            Object obj = DROP_WHILE_METHOD_HANDLE.invoke(stream, predicate);
            return (Stream)obj;
        }
        catch (Throwable t) {
            throw new JPAStreamerException(t);
        }
    }

    static <T> Stream<T> filter(Stream<T> stream, Predicate<? super T> predicate) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(predicate);
        try {
            Stream s = FILTER_METHOD_HANDLE.invoke(stream, predicate);
            return s;
        }
        catch (Throwable t) {
            throw new JPAStreamerException(t);
        }
    }

    private static MethodHandle createMethodHandle(String methodName, Class<?> refc, MethodType methodType) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return lookup.findVirtual(refc, methodName, methodType);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    private static UnsupportedOperationException newUnsupportedOperationException(String methodName) {
        return new UnsupportedOperationException("Stream::" + methodName + " is not supported by this Java version. Use Java 9 or greater.");
    }
}

