/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal;

import com.speedment.jpastreamer.field.ComparableField;
import com.speedment.jpastreamer.field.Field;
import com.speedment.jpastreamer.field.comparator.FieldComparator;
import com.speedment.jpastreamer.field.comparator.NullOrder;
import com.speedment.jpastreamer.field.internal.comparator.ReferenceFieldComparatorImpl;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceBetweenPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceGreaterOrEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceGreaterThanPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceInPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceIsNullPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceLessOrEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceLessThanPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceNotBetweenPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceNotEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.reference.ReferenceNotInPredicate;
import com.speedment.jpastreamer.field.internal.util.CollectionUtil;
import com.speedment.jpastreamer.field.method.ReferenceGetter;
import com.speedment.jpastreamer.field.predicate.FieldPredicate;
import com.speedment.jpastreamer.field.predicate.Inclusion;
import com.speedment.jpastreamer.field.predicate.SpeedmentPredicate;
import java.util.Collection;
import java.util.Objects;

public final class ComparableFieldImpl<ENTITY, V extends Comparable<? super V>>
implements ComparableField<ENTITY, V>,
FieldComparator<ENTITY> {
    private final Class<ENTITY> table;
    private final String columnName;
    private final ReferenceGetter<ENTITY, V> getter;
    private final boolean unique;

    public ComparableFieldImpl(Class<ENTITY> table, String columnName, ReferenceGetter<ENTITY, V> getter, boolean unique) {
        this.table = Objects.requireNonNull(table);
        this.columnName = Objects.requireNonNull(columnName);
        this.getter = Objects.requireNonNull(getter);
        this.unique = unique;
    }

    @Override
    public Class<ENTITY> table() {
        return this.table;
    }

    @Override
    public ReferenceGetter<ENTITY, V> getter() {
        return this.getter;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public FieldComparator<ENTITY> comparator() {
        return new ReferenceFieldComparatorImpl(this, NullOrder.LAST);
    }

    @Override
    public FieldComparator<ENTITY> comparatorNullFieldsFirst() {
        return new ReferenceFieldComparatorImpl(this, NullOrder.FIRST);
    }

    @Override
    public Field<ENTITY> getField() {
        return this;
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.LAST;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public FieldComparator<ENTITY> reversed() {
        return this.comparator().reversed();
    }

    @Override
    public int compare(ENTITY first, ENTITY second) {
        Comparable f = (Comparable)this.get(first);
        Comparable s = (Comparable)this.get(second);
        if (f == null && s == null) {
            return 0;
        }
        if (f == null) {
            return 1;
        }
        if (s == null) {
            return -1;
        }
        return f.compareTo(s);
    }

    @Override
    public FieldPredicate<ENTITY> isNull() {
        return new ReferenceIsNullPredicate(this);
    }

    @Override
    public FieldPredicate<ENTITY> equal(V value) {
        return new ReferenceEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEqual(V value) {
        return new ReferenceNotEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> greaterThan(V value) {
        return new ReferenceGreaterThanPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> greaterOrEqual(V value) {
        return new ReferenceGreaterOrEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessThan(V value) {
        return new ReferenceLessThanPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessOrEqual(V value) {
        return new ReferenceLessOrEqualPredicate(this, value);
    }

    @Override
    public SpeedmentPredicate<ENTITY> between(V start, V end, Inclusion inclusion) {
        return new ReferenceBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notBetween(V start, V end, Inclusion inclusion) {
        return new ReferenceNotBetweenPredicate(this, start, end, inclusion);
    }

    @Override
    public SpeedmentPredicate<ENTITY> in(Collection<V> values) {
        return new ReferenceInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public SpeedmentPredicate<ENTITY> notIn(Collection<V> values) {
        return new ReferenceNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public String columnName() {
        return this.columnName;
    }
}

