/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal;

import com.speedment.jpastreamer.field.FloatField;
import com.speedment.jpastreamer.field.comparator.FloatFieldComparator;
import com.speedment.jpastreamer.field.comparator.NullOrder;
import com.speedment.jpastreamer.field.internal.comparator.FloatFieldComparatorImpl;
import com.speedment.jpastreamer.field.internal.method.GetFloatImpl;
import com.speedment.jpastreamer.field.internal.predicate.floats.FloatBetweenPredicate;
import com.speedment.jpastreamer.field.internal.predicate.floats.FloatEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.floats.FloatGreaterOrEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.floats.FloatGreaterThanPredicate;
import com.speedment.jpastreamer.field.internal.predicate.floats.FloatInPredicate;
import com.speedment.jpastreamer.field.internal.predicate.floats.FloatLessOrEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.floats.FloatLessThanPredicate;
import com.speedment.jpastreamer.field.internal.predicate.floats.FloatNotBetweenPredicate;
import com.speedment.jpastreamer.field.internal.predicate.floats.FloatNotEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.floats.FloatNotInPredicate;
import com.speedment.jpastreamer.field.internal.util.CollectionUtil;
import com.speedment.jpastreamer.field.method.FloatGetter;
import com.speedment.jpastreamer.field.method.GetFloat;
import com.speedment.jpastreamer.field.predicate.FieldPredicate;
import com.speedment.jpastreamer.field.predicate.Inclusion;
import com.speedment.jpastreamer.field.predicate.SpeedmentPredicate;
import java.util.Collection;
import java.util.Objects;

public final class FloatFieldImpl<ENTITY>
implements FloatField<ENTITY> {
    private final Class<ENTITY> table;
    private final String columnName;
    private final GetFloat<ENTITY> getter;
    private final boolean unique;

    public FloatFieldImpl(Class<ENTITY> table, String columnName, FloatGetter<ENTITY> getter, boolean unique) {
        this.table = Objects.requireNonNull(table);
        this.columnName = Objects.requireNonNull(columnName);
        this.getter = new GetFloatImpl<ENTITY>(this, getter);
        this.unique = unique;
    }

    @Override
    public Class<ENTITY> table() {
        return this.table;
    }

    @Override
    public GetFloat<ENTITY> getter() {
        return this.getter;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public FloatFieldComparator<ENTITY> comparator() {
        return new FloatFieldComparatorImpl(this);
    }

    @Override
    public FloatFieldComparator<ENTITY> reversed() {
        return this.comparator().reversed();
    }

    @Override
    public FloatFieldComparator<ENTITY> comparatorNullFieldsFirst() {
        return this.comparator();
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.LAST;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public FieldPredicate<ENTITY> equal(Float value) {
        return new FloatEqualPredicate(this, value.floatValue());
    }

    @Override
    public FieldPredicate<ENTITY> greaterThan(Float value) {
        return new FloatGreaterThanPredicate(this, value.floatValue());
    }

    @Override
    public FieldPredicate<ENTITY> greaterOrEqual(Float value) {
        return new FloatGreaterOrEqualPredicate(this, value.floatValue());
    }

    @Override
    public FieldPredicate<ENTITY> between(Float start, Float end, Inclusion inclusion) {
        return new FloatBetweenPredicate(this, start.floatValue(), end.floatValue(), inclusion);
    }

    @Override
    public FieldPredicate<ENTITY> in(Collection<Float> values) {
        return new FloatInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEqual(Float value) {
        return new FloatNotEqualPredicate(this, value.floatValue());
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessOrEqual(Float value) {
        return new FloatLessOrEqualPredicate(this, value.floatValue());
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessThan(Float value) {
        return new FloatLessThanPredicate(this, value.floatValue());
    }

    @Override
    public SpeedmentPredicate<ENTITY> notBetween(Float start, Float end, Inclusion inclusion) {
        return new FloatNotBetweenPredicate(this, start.floatValue(), end.floatValue(), inclusion);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notIn(Collection<Float> values) {
        return new FloatNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public String columnName() {
        return this.columnName;
    }
}

