/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.field.internal;

import com.speedment.jpastreamer.field.CharField;
import com.speedment.jpastreamer.field.comparator.CharFieldComparator;
import com.speedment.jpastreamer.field.comparator.NullOrder;
import com.speedment.jpastreamer.field.internal.comparator.CharFieldComparatorImpl;
import com.speedment.jpastreamer.field.internal.method.GetCharImpl;
import com.speedment.jpastreamer.field.internal.predicate.chars.CharBetweenPredicate;
import com.speedment.jpastreamer.field.internal.predicate.chars.CharEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.chars.CharGreaterOrEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.chars.CharGreaterThanPredicate;
import com.speedment.jpastreamer.field.internal.predicate.chars.CharInPredicate;
import com.speedment.jpastreamer.field.internal.predicate.chars.CharLessOrEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.chars.CharLessThanPredicate;
import com.speedment.jpastreamer.field.internal.predicate.chars.CharNotBetweenPredicate;
import com.speedment.jpastreamer.field.internal.predicate.chars.CharNotEqualPredicate;
import com.speedment.jpastreamer.field.internal.predicate.chars.CharNotInPredicate;
import com.speedment.jpastreamer.field.internal.util.CollectionUtil;
import com.speedment.jpastreamer.field.method.CharGetter;
import com.speedment.jpastreamer.field.method.GetChar;
import com.speedment.jpastreamer.field.predicate.FieldPredicate;
import com.speedment.jpastreamer.field.predicate.Inclusion;
import com.speedment.jpastreamer.field.predicate.SpeedmentPredicate;
import java.util.Collection;
import java.util.Objects;

public final class CharFieldImpl<ENTITY>
implements CharField<ENTITY> {
    private final Class<ENTITY> table;
    private final String columnName;
    private final GetChar<ENTITY> getter;
    private final boolean unique;

    public CharFieldImpl(Class<ENTITY> table, String columnName, CharGetter<ENTITY> getter, boolean unique) {
        this.table = Objects.requireNonNull(table);
        this.columnName = Objects.requireNonNull(columnName);
        this.getter = new GetCharImpl<ENTITY>(this, getter);
        this.unique = unique;
    }

    @Override
    public Class<ENTITY> table() {
        return this.table;
    }

    @Override
    public GetChar<ENTITY> getter() {
        return this.getter;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public CharFieldComparator<ENTITY> comparator() {
        return new CharFieldComparatorImpl(this);
    }

    @Override
    public CharFieldComparator<ENTITY> reversed() {
        return this.comparator().reversed();
    }

    @Override
    public CharFieldComparator<ENTITY> comparatorNullFieldsFirst() {
        return this.comparator();
    }

    @Override
    public NullOrder getNullOrder() {
        return NullOrder.LAST;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public FieldPredicate<ENTITY> equal(Character value) {
        return new CharEqualPredicate(this, value.charValue());
    }

    @Override
    public FieldPredicate<ENTITY> greaterThan(Character value) {
        return new CharGreaterThanPredicate(this, value.charValue());
    }

    @Override
    public FieldPredicate<ENTITY> greaterOrEqual(Character value) {
        return new CharGreaterOrEqualPredicate(this, value.charValue());
    }

    @Override
    public FieldPredicate<ENTITY> between(Character start, Character end, Inclusion inclusion) {
        return new CharBetweenPredicate(this, start.charValue(), end.charValue(), inclusion);
    }

    @Override
    public FieldPredicate<ENTITY> in(Collection<Character> values) {
        return new CharInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public SpeedmentPredicate<ENTITY> notEqual(Character value) {
        return new CharNotEqualPredicate(this, value.charValue());
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessOrEqual(Character value) {
        return new CharLessOrEqualPredicate(this, value.charValue());
    }

    @Override
    public SpeedmentPredicate<ENTITY> lessThan(Character value) {
        return new CharLessThanPredicate(this, value.charValue());
    }

    @Override
    public SpeedmentPredicate<ENTITY> notBetween(Character start, Character end, Inclusion inclusion) {
        return new CharNotBetweenPredicate(this, start.charValue(), end.charValue(), inclusion);
    }

    @Override
    public SpeedmentPredicate<ENTITY> notIn(Collection<Character> values) {
        return new CharNotInPredicate(this, CollectionUtil.collectionToSet(values));
    }

    @Override
    public String columnName() {
        return this.columnName;
    }
}

