/*
 * JPAstreamer - Express JPA queries with Java Streams
 * Copyright (c) 2020-2022, Speedment, Inc. All Rights Reserved.
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * See: https://github.com/speedment/jpa-streamer/blob/master/LICENSE
 */
package com.speedment.jpastreamer.field.predicate;

import com.speedment.jpastreamer.field.predicate.trait.HasPredicateType;
import com.speedment.jpastreamer.field.predicate.trait.HasField;

import java.util.function.Predicate;

/**
 * The base interface for all {@link Predicate predicates} generated by
 * Speedment entity fields.
 * 
 * @param <ENTITY>  the entity type that is being tested
 * 
 * @author  Per Minborg
 * @since   2.1.0
 */
public interface FieldPredicate<ENTITY>
extends SpeedmentPredicate<ENTITY>,
        HasField<ENTITY>,
        HasPredicateType {

    @Override
    FieldPredicate<ENTITY> negate();
}
