/*
 * JPAstreamer - Express JPA queries with Java Streams
 * Copyright (c) 2020-2022, Speedment, Inc. All Rights Reserved.
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * See: https://github.com/speedment/jpa-streamer/blob/master/LICENSE
 */
package com.speedment.jpastreamer.field;

import com.speedment.jpastreamer.field.trait.HasComparableOperators;
import com.speedment.runtime.compute.ToShort;
import com.speedment.jpastreamer.field.comparator.ShortFieldComparator;
import com.speedment.jpastreamer.field.internal.ShortFieldImpl;
import com.speedment.jpastreamer.field.method.ShortGetter;
import com.speedment.jpastreamer.field.trait.HasShortValue;

/**
 * A field that represents a primitive {@code short} value.
 * <p>
 * Generated by com.speedment.sources.pattern.FieldPattern.
 * 
 * @param <ENTITY> entity type
 *
 * @author Emil Forslund
 * @since  3.0.0
 */
public interface ShortField<ENTITY> extends
        Field<ENTITY>,
        HasShortValue<ENTITY>,
        HasComparableOperators<ENTITY, Short>,
        ToShort<ENTITY>,
        ShortFieldComparator<ENTITY> {
    
    /**
     * Creates a new {@link ShortField} using the default implementation.
     * 
     * @param <ENTITY>   entity type
     * @param table      the table that this field belongs to
     * @param columnName the name of the database column the field represents
     * @param getter     method reference to getter in entity
     * @param unique     if column only contains unique values
     * @return           the created field
     */
    static <ENTITY> ShortField<ENTITY> create(
            Class<ENTITY> table,
            String columnName,
            ShortGetter<ENTITY> getter,
            boolean unique) {
        return new ShortFieldImpl<>(
                table, columnName, getter, unique
        );
    }
    
    @Override
    default short applyAsShort(ENTITY entity) {
        return getAsShort(entity);
    }
    
    @Override
    ShortFieldComparator<ENTITY> comparator();
    
    @Override
    default ShortFieldComparator<ENTITY> reversed() {
        return comparator().reversed();
    }
    
    @Override
    default ShortField<ENTITY> getField() {
        return this;
    }
}
