/*
 * JPAstreamer - Express JPA queries with Java Streams
 * Copyright (c) 2020-2022, Speedment, Inc. All Rights Reserved.
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * See: https://github.com/speedment/jpa-streamer/blob/master/LICENSE
 */
package com.speedment.jpastreamer.field;

import com.speedment.jpastreamer.field.internal.LongFieldImpl;
import com.speedment.jpastreamer.field.method.LongGetter;
import com.speedment.jpastreamer.field.trait.HasComparableOperators;
import com.speedment.jpastreamer.field.trait.HasLongValue;
import com.speedment.runtime.compute.ToLong;
import com.speedment.jpastreamer.field.comparator.LongFieldComparator;

/**
 * A field that represents a primitive {@code long} value.
 * <p>
 * Generated by com.speedment.sources.pattern.FieldPattern.
 * 
 * @param <ENTITY> entity type
 *
 * @author Emil Forslund
 * @since  3.0.0
 */
public interface LongField<ENTITY> extends
        Field<ENTITY>,
        HasLongValue<ENTITY>,
        HasComparableOperators<ENTITY, Long>,
        ToLong<ENTITY>,
        LongFieldComparator<ENTITY> {
    
    /**
     * Creates a new {@link LongField} using the default implementation.
     * 
     * @param <ENTITY>   entity type
     * @param table      the table that this field belongs to
     * @param columnName the name of the database column the field represents
     * @param getter     method reference to getter in entity
     * @param unique     if column only contains unique values
     * @return           the created field
     */
    static <ENTITY> LongField<ENTITY> create(
            Class<ENTITY> table,
            String columnName,
            LongGetter<ENTITY> getter,
            boolean unique) {
        return new LongFieldImpl<>(
                table, columnName, getter, unique
        );
    }

    @Override
    default long applyAsLong(ENTITY entity) {
        return getAsLong(entity);
    }
    
    @Override
    LongFieldComparator<ENTITY> comparator();
    
    @Override
    default LongFieldComparator<ENTITY> reversed() {
        return comparator().reversed();
    }
    
    @Override
    default LongField<ENTITY> getField() {
        return this;
    }
}
