/*
 * JPAstreamer - Express JPA queries with Java Streams
 * Copyright (c) 2020-2022, Speedment, Inc. All Rights Reserved.
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * See: https://github.com/speedment/jpa-streamer/blob/master/LICENSE
 */
package com.speedment.jpastreamer.field;

import com.speedment.jpastreamer.field.comparator.IntFieldComparator;
import com.speedment.jpastreamer.field.internal.IntFieldImpl;
import com.speedment.jpastreamer.field.method.IntGetter;
import com.speedment.jpastreamer.field.trait.HasComparableOperators;
import com.speedment.jpastreamer.field.trait.HasIntValue;
import com.speedment.runtime.compute.ToInt;

/**
 * A field that represents a primitive {@code int} value.
 * <p>
 * Generated by com.speedment.sources.pattern.FieldPattern.
 * 
 * @param <ENTITY> entity type
 *
 * @author Emil Forslund
 * @since  3.0.0
 */
public interface IntField<ENTITY> extends
        Field<ENTITY>,
        HasIntValue<ENTITY>,
        HasComparableOperators<ENTITY, Integer>,
        ToInt<ENTITY>,
        IntFieldComparator<ENTITY> {
    
    /**
     * Creates a new {@link IntField} using the default implementation.
     * 
     * @param <ENTITY>   entity type
     * @param table      the table that this field belongs to
     * @param columnName the name of the database column the field represents
     * @param getter     method reference to getter in entity
     * @param unique     if column only contains unique values
     * @return           the created field
     */
    static <ENTITY> IntField<ENTITY> create(
            Class<ENTITY> table,
            String columnName,
            IntGetter<ENTITY> getter,
            boolean unique) {
        return new IntFieldImpl<>(
                table, columnName, getter, unique
        );
    }

    @Override
    default int applyAsInt(ENTITY entity) {
        return getAsInt(entity);
    }
    
    @Override
    IntFieldComparator<ENTITY> comparator();
    
    @Override
    default IntFieldComparator<ENTITY> reversed() {
        return comparator().reversed();
    }
    
    @Override
    default IntField<ENTITY> getField() {
        return this;
    }
}
