/*
 * JPAstreamer - Express JPA queries with Java Streams
 * Copyright (c) 2020-2022, Speedment, Inc. All Rights Reserved.
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * See: https://github.com/speedment/jpa-streamer/blob/master/LICENSE
 */
package com.speedment.jpastreamer.field;

import com.speedment.jpastreamer.field.method.CharGetter;
import com.speedment.runtime.compute.ToChar;
import com.speedment.jpastreamer.field.comparator.CharFieldComparator;
import com.speedment.jpastreamer.field.internal.CharFieldImpl;
import com.speedment.jpastreamer.field.trait.HasCharValue;
import com.speedment.jpastreamer.field.trait.HasComparableOperators;

/**
 * A field that represents a primitive {@code char} value.
 * <p>
 * Generated by com.speedment.sources.pattern.FieldPattern.
 * 
 * @param <ENTITY> entity type
 *
 * @author Emil Forslund
 * @since  3.0.0
 */
public interface CharField<ENTITY> extends
        Field<ENTITY>,
        HasCharValue<ENTITY>,
        HasComparableOperators<ENTITY, Character>,
        ToChar<ENTITY>,
        CharFieldComparator<ENTITY> {

    /**
     * Creates a new {@link CharField} using the default implementation.
     * 
     * @param <ENTITY>   entity type
     * @param table      the table that the field belongs to
     * @param columnName the name of the database column the field represents
     * @param getter     method reference to getter in entity
     * @param unique     if column only contains unique values
     * @return           the created field
     */
    static <ENTITY> CharField<ENTITY> create(
            Class<ENTITY> table,
            String columnName,
            CharGetter<ENTITY> getter,
            boolean unique) {
        return new CharFieldImpl<>(
                table, columnName, getter, unique
        );
    }

    @Override
    default char applyAsChar(ENTITY entity) {
        return getAsChar(entity);
    }
    
    @Override
    CharFieldComparator<ENTITY> comparator();
    
    @Override
    default CharFieldComparator<ENTITY> reversed() {
        return comparator().reversed();
    }
    
    @Override
    default CharField<ENTITY> getField() {
        return this;
    }
}
