/*
 * JPAstreamer - Express JPA queries with Java Streams
 * Copyright (c) 2020-2022, Speedment, Inc. All Rights Reserved.
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * See: https://github.com/speedment/jpa-streamer/blob/master/LICENSE
 */
package com.speedment.jpastreamer.field;

import com.speedment.runtime.compute.ToByte;
import com.speedment.jpastreamer.field.comparator.ByteFieldComparator;
import com.speedment.jpastreamer.field.internal.ByteFieldImpl;
import com.speedment.jpastreamer.field.method.ByteGetter;
import com.speedment.jpastreamer.field.trait.HasByteValue;
import com.speedment.jpastreamer.field.trait.HasComparableOperators;

/**
 * A field that represents a primitive {@code byte} value.
 * <p>
 * Generated by com.speedment.sources.pattern.FieldPattern.
 * 
 * @param <ENTITY> entity type
 *
 * @author Emil Forslund
 * @since  3.0.0
 */
public interface ByteField<ENTITY> extends Field<ENTITY>,
        HasByteValue<ENTITY>,
        HasComparableOperators<ENTITY, Byte>,
        ToByte<ENTITY>,
        ByteFieldComparator<ENTITY> {
    /**
     * Creates a new {@link ByteField} using the default implementation.
     * 
     * @param <ENTITY>   entity type
     * @param table      the table that the field belongs to
     * @param columnName the name of the database column the field represents
     * @param getter     method reference to getter in entity
     * @param unique     if column only contains unique values
     * @return           the created field
     */
    static <ENTITY> ByteField<ENTITY> create(
            Class<ENTITY> table,
            String columnName,
            ByteGetter<ENTITY> getter,
            boolean unique) {
        return new ByteFieldImpl<>(
                table, columnName, getter, unique
        );
    }
    
    @Override
    default byte applyAsByte(ENTITY entity) {
        return getAsByte(entity);
    }
    
    @Override
    ByteFieldComparator<ENTITY> comparator();
    
    @Override
    default ByteFieldComparator<ENTITY> reversed() {
        return comparator().reversed();
    }
    
    @Override
    default ByteField<ENTITY> getField() {
        return this;
    }
}
