/*
 * JPAstreamer - Express JPA queries with Java Streams
 * Copyright (c) 2020-2022, Speedment, Inc. All Rights Reserved.
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * See: https://github.com/speedment/jpa-streamer/blob/master/LICENSE
 */
package com.speedment.jpastreamer.field;

import com.speedment.runtime.compute.ToBoolean;
import com.speedment.jpastreamer.field.comparator.BooleanFieldComparator;
import com.speedment.jpastreamer.field.internal.BooleanFieldImpl;
import com.speedment.jpastreamer.field.method.BooleanGetter;
import com.speedment.jpastreamer.field.trait.HasBooleanOperators;
import com.speedment.jpastreamer.field.trait.HasBooleanValue;

/**
 * A field that represents a primitive {@code boolean} value.
 * <p>
 * Generated by com.speedment.sources.pattern.FieldPattern.
 *
 * @param <ENTITY> entity type
 *
 * @author Emil Forslund
 * @since  3.0.0
 */
public interface BooleanField<ENTITY> extends Field<ENTITY>,
        HasBooleanValue<ENTITY>,
        ToBoolean<ENTITY>,
        BooleanFieldComparator<ENTITY>,
        HasBooleanOperators<ENTITY> {

    /**
     * Creates a new {@link BooleanField} using the default implementation.
     *
     * @param <ENTITY>   entity type
     * @param table      the table that the field belongs to
     * @param columnName the name of the database column the field represents
     * @param getter     method reference to getter in entity
     * @param unique     if column only contains unique values
     * @return           the created field
     */
    static <ENTITY> BooleanField<ENTITY> create(
    Class<ENTITY> table,
            String columnName,
            BooleanGetter<ENTITY> getter,
            boolean unique) {
        return new BooleanFieldImpl<>(
            table, columnName, getter, unique
        );
    }

    @Override
    default boolean applyAsBoolean(ENTITY entity) {
        return getAsBoolean(entity);
    }

    @Override
    default BooleanField<ENTITY> getField() {
        return this;
    }
}
