/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.application.standard.internal;

import com.speedment.jpastreamer.application.StreamSupplier;
import com.speedment.jpastreamer.autoclose.AutoCloseFactory;
import com.speedment.jpastreamer.builder.BuilderFactory;
import com.speedment.jpastreamer.renderer.Renderer;
import com.speedment.jpastreamer.renderer.RendererFactory;
import com.speedment.jpastreamer.rootfactory.RootFactory;
import com.speedment.jpastreamer.streamconfiguration.StreamConfiguration;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Stream;

final class StandardStreamSupplier<T>
implements StreamSupplier<T> {
    private final Renderer renderer;
    private final BuilderFactory builderFactory;
    private final AutoCloseFactory autoCloseFactory;
    private final StreamConfiguration<T> streamConfiguration;
    private final boolean closeEntityManager;
    private static final AtomicBoolean closed = new AtomicBoolean(false);

    StandardStreamSupplier(StreamConfiguration<T> streamConfiguration, EntityManagerFactory entityManagerFactory, boolean closeEntityManager) {
        this(streamConfiguration, () -> ((EntityManagerFactory)entityManagerFactory).createEntityManager(), closeEntityManager);
    }

    StandardStreamSupplier(StreamConfiguration<T> streamConfiguration, Supplier<EntityManager> entityManagerSupplier, boolean closeEntityManager) {
        this.streamConfiguration = Objects.requireNonNull(streamConfiguration);
        Objects.requireNonNull(entityManagerSupplier);
        this.builderFactory = (BuilderFactory)RootFactory.getOrThrow(BuilderFactory.class, ServiceLoader::load);
        this.autoCloseFactory = (AutoCloseFactory)RootFactory.getOrThrow(AutoCloseFactory.class, ServiceLoader::load);
        this.renderer = ((RendererFactory)RootFactory.getOrThrow(RendererFactory.class, ServiceLoader::load)).createRenderer(entityManagerSupplier);
        this.closeEntityManager = closeEntityManager;
    }

    StandardStreamSupplier(StreamConfiguration<T> streamConfiguration, EntityManager entityManager, boolean closeEntityManager) {
        this.streamConfiguration = Objects.requireNonNull(streamConfiguration);
        Objects.requireNonNull(entityManager);
        this.builderFactory = (BuilderFactory)RootFactory.getOrThrow(BuilderFactory.class, ServiceLoader::load);
        this.autoCloseFactory = (AutoCloseFactory)RootFactory.getOrThrow(AutoCloseFactory.class, ServiceLoader::load);
        this.renderer = ((RendererFactory)RootFactory.getOrThrow(RendererFactory.class, ServiceLoader::load)).createRenderer(entityManager);
        this.closeEntityManager = closeEntityManager;
    }

    public Stream<T> stream() {
        return this.autoCloseFactory.createAutoCloseStream(this.builderFactory.createBuilder(this.streamConfiguration, this.renderer));
    }

    public void close() {
        if (this.closeEntityManager) {
            this.renderer.close();
        } else if (closed.compareAndSet(false, true)) {
            System.out.println("JPAStreamer does not close Entity Managers obtained by a given Supplier<EntityManager>.");
        }
    }

    public StreamConfiguration<T> configuration() {
        return this.streamConfiguration;
    }
}

