/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.application.standard.internal;

import com.speedment.jpastreamer.application.JPAStreamer;
import com.speedment.jpastreamer.application.JPAStreamerBuilder;
import com.speedment.jpastreamer.application.standard.internal.StandardJPAStreamer;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.util.Objects;
import java.util.function.Supplier;

public final class StandardJPAStreamerBuilder
implements JPAStreamerBuilder {
    private final Supplier<EntityManager> entityManagerSupplier;
    private final Runnable closeHandler;
    private final boolean demoMode;
    private final boolean closeEntityManagers;

    public StandardJPAStreamerBuilder(String persistenceUnitName) {
        Objects.requireNonNull(persistenceUnitName);
        EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)persistenceUnitName);
        this.entityManagerSupplier = () -> ((EntityManagerFactory)entityManagerFactory).createEntityManager();
        this.closeHandler = () -> ((EntityManagerFactory)entityManagerFactory).close();
        this.demoMode = "sakila".equals(persistenceUnitName);
        this.closeEntityManagers = true;
    }

    public StandardJPAStreamerBuilder(EntityManagerFactory entityManagerFactory) {
        Objects.requireNonNull(entityManagerFactory);
        this.entityManagerSupplier = () -> ((EntityManagerFactory)entityManagerFactory).createEntityManager();
        this.closeHandler = () -> {};
        this.demoMode = "sakila".equals(entityManagerFactory.getProperties().getOrDefault("hibernate.ejb.persistenceUnitName", ""));
        this.closeEntityManagers = true;
    }

    public StandardJPAStreamerBuilder(Supplier<EntityManager> entityManagerSupplier) {
        this.entityManagerSupplier = Objects.requireNonNull(entityManagerSupplier);
        this.closeHandler = () -> {};
        this.demoMode = false;
        this.closeEntityManagers = false;
    }

    public JPAStreamer build() {
        return new StandardJPAStreamer(this.entityManagerSupplier, this.closeHandler, this.demoMode, this.closeEntityManagers);
    }
}

