/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.application.standard.internal;

import com.speedment.jpastreamer.application.standard.internal.Streamer;
import com.speedment.jpastreamer.autoclose.AutoCloseFactory;
import com.speedment.jpastreamer.builder.BuilderFactory;
import com.speedment.jpastreamer.renderer.Renderer;
import com.speedment.jpastreamer.renderer.RendererFactory;
import com.speedment.jpastreamer.rootfactory.RootFactory;
import com.speedment.jpastreamer.streamconfiguration.StreamConfiguration;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Stream;

final class StandardStreamer<T>
implements Streamer<T> {
    private final Renderer renderer;
    private final BuilderFactory builderFactory;
    private final AutoCloseFactory autoCloseFactory;
    private final StreamConfiguration<T> streamConfiguration;

    StandardStreamer(StreamConfiguration<T> streamConfiguration, EntityManagerFactory entityManagerFactory) {
        this(streamConfiguration, () -> ((EntityManagerFactory)entityManagerFactory).createEntityManager());
    }

    StandardStreamer(StreamConfiguration<T> streamConfiguration, Supplier<EntityManager> entityManagerSupplier) {
        this.streamConfiguration = Objects.requireNonNull(streamConfiguration);
        Objects.requireNonNull(entityManagerSupplier);
        this.builderFactory = (BuilderFactory)RootFactory.getOrThrow(BuilderFactory.class, ServiceLoader::load);
        this.autoCloseFactory = (AutoCloseFactory)RootFactory.getOrThrow(AutoCloseFactory.class, ServiceLoader::load);
        this.renderer = ((RendererFactory)RootFactory.getOrThrow(RendererFactory.class, ServiceLoader::load)).createRenderer(entityManagerSupplier);
    }

    StandardStreamer(StreamConfiguration<T> streamConfiguration, EntityManager entityManager) {
        this.streamConfiguration = Objects.requireNonNull(streamConfiguration);
        Objects.requireNonNull(entityManager);
        this.builderFactory = (BuilderFactory)RootFactory.getOrThrow(BuilderFactory.class, ServiceLoader::load);
        this.autoCloseFactory = (AutoCloseFactory)RootFactory.getOrThrow(AutoCloseFactory.class, ServiceLoader::load);
        this.renderer = ((RendererFactory)RootFactory.getOrThrow(RendererFactory.class, ServiceLoader::load)).createRenderer(entityManager);
    }

    @Override
    public Stream<T> stream() {
        return this.autoCloseFactory.createAutoCloseStream(this.builderFactory.createBuilder(this.streamConfiguration, this.renderer));
    }

    @Override
    public void close() {
        this.renderer.close();
    }
}

