/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.analytics.standard.internal.google;

import com.speedment.common.rest.Rest;
import com.speedment.jpastreamer.analytics.standard.internal.Handler;
import com.speedment.jpastreamer.analytics.standard.internal.google.EventType;
import com.speedment.jpastreamer.analytics.standard.internal.google.HttpUtil;
import com.speedment.jpastreamer.analytics.standard.internal.google.JsonUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class GoogleAnalyticsHandler
implements Handler {
    private static final String COOKIE_FILE_NAME = "JPAstreamer.clientid";
    private static final String URL_STRING = "https://www.google-analytics.com/mp/collect";
    private static final String MEASUREMENT_ID = "G-LNCF0RTS4N";
    private static final String API_SECRET = "J-EHimWhT8anCwaHfq-h-Q";
    private final String version;
    private final boolean demoMode;
    private final String clientId;
    private final Random random;
    private final Rest analytics;

    public GoogleAnalyticsHandler(String version, boolean demoMode) {
        this.version = Objects.requireNonNull(version);
        this.demoMode = demoMode;
        this.clientId = this.acquireClientId();
        this.random = new SecureRandom();
        this.analytics = Rest.connectHttps((String)URL_STRING);
    }

    @Override
    public void starting() {
        this.report(EventType.STARTED);
    }

    @Override
    public void running() {
        this.report(EventType.ALIVE);
    }

    @Override
    public void stopping() {
        this.report(EventType.STOPPED);
    }

    private void report(EventType eventType) {
        Objects.requireNonNull(eventType);
        String eventName = eventType.eventName() + (this.demoMode ? "-demo" : "");
        HashMap<String, String> eventParameters = new HashMap<String, String>();
        HashMap userProperties = new HashMap();
        eventParameters.put("app_version", this.version);
        this.httpSend(eventName, eventParameters);
    }

    void httpSend(String eventName, Map<String, String> eventParameters) {
        Objects.requireNonNull(eventName);
        Objects.requireNonNull(eventParameters);
        String url = "https://www.google-analytics.com/mp/collect?measurement_id=" + HttpUtil.urlEncode(MEASUREMENT_ID) + "&api_secret=" + HttpUtil.urlEncode(API_SECRET);
        String json = GoogleAnalyticsHandler.jsonFor(eventName, this.acquireClientId(), eventParameters);
        HttpUtil.send(url, json);
    }

    private String acquireClientId() {
        String string;
        block10: {
            String userHome = System.getProperty("user.home");
            Path path2 = Paths.get(userHome, COOKIE_FILE_NAME);
            Stream<String> lines = Files.lines(path2, StandardCharsets.UTF_8);
            try {
                string = lines.findFirst().map(UUID::fromString).orElseThrow(NoSuchElementException::new).toString();
                if (lines == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception path2) {
                    String clientId = UUID.randomUUID().toString();
                    try {
                        Path path3 = Paths.get(userHome, COOKIE_FILE_NAME);
                        Files.write(path3, clientId.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return clientId;
                }
            }
            lines.close();
        }
        return string;
    }

    static String jsonFor(String eventName, String clientId) {
        Objects.requireNonNull(eventName);
        Objects.requireNonNull(clientId);
        return Stream.of("{", JsonUtil.jsonElement(" ", "clientId", clientId) + ",", JsonUtil.jsonElement(" ", "userId", clientId) + ",", JsonUtil.jsonElement(" ", "nonPersonalizedAds", true) + ",", " " + JsonUtil.asElement("events") + ": [{", JsonUtil.jsonElement("  ", "name", eventName) + ",", "  " + JsonUtil.asElement("params") + ": {}", " }],", " " + JsonUtil.asElement("userProperties") + ": {}", "}").collect(Collectors.joining(JsonUtil.nl()));
    }

    static String jsonFor(String eventName, String clientId, Map<String, String> eventParameters) {
        Objects.requireNonNull(eventName);
        Objects.requireNonNull(clientId);
        Objects.requireNonNull(eventParameters);
        return Stream.of("{", JsonUtil.jsonElement(" ", "clientId", clientId) + ",", JsonUtil.jsonElement(" ", "userId", clientId) + ",", JsonUtil.jsonElement(" ", "nonPersonalizedAds", true) + ",", " " + JsonUtil.asElement("events") + ": [{", JsonUtil.jsonElement("  ", "name", eventName) + ",", "  " + JsonUtil.asElement("params") + ": {", GoogleAnalyticsHandler.renderMap(eventParameters, e -> JsonUtil.jsonElement("   ", (String)e.getKey(), e.getValue())), "  }", " }]", "}").collect(Collectors.joining(JsonUtil.nl()));
    }

    static String userProperty(Map.Entry<String, String> userProperty) {
        return String.format("  %s: {%n %s%n  }", JsonUtil.asElement(userProperty.getKey()), JsonUtil.jsonElement("   ", "value", userProperty.getValue()));
    }

    static String renderMap(Map<String, String> map, Function<Map.Entry<String, String>, String> mapper) {
        Objects.requireNonNull(map);
        Objects.requireNonNull(mapper);
        return map.entrySet().stream().map(mapper).collect(Collectors.joining(String.format(",%n", new Object[0])));
    }
}

