/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.rest;

import com.speedment.common.rest.AbstractOption;
import com.speedment.common.rest.Option;
import com.speedment.common.rest.Param;
import com.speedment.common.rest.Rest;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class RestException
extends RuntimeException {
    private static final long serialVersionUID = 1783560981699960801L;
    private final Rest.Protocol protocol;
    private final Rest.Method method;
    private final String host;
    private final int port;
    private final String username;
    private final String path;

    public RestException(Throwable cause, Rest.Protocol protocol, Rest.Method method, String username, String host, int port, String path, Option[] options) {
        super(RestException.message(protocol, method, username, host, port, path, options), cause);
        this.protocol = Objects.requireNonNull(protocol);
        this.method = Objects.requireNonNull(method);
        this.host = Objects.requireNonNull(host);
        this.port = port;
        this.username = username;
        this.path = path;
    }

    @Override
    public String toString() {
        return "RestException{protocol=" + (Object)((Object)this.protocol) + ", method=" + (Object)((Object)this.method) + ", host='" + this.host + '\'' + ", port=" + this.port + ", username='" + this.username + '\'' + ", path='" + this.path + '\'' + '}';
    }

    private static String message(Rest.Protocol protocol, Rest.Method method, String username, String host, int port, String path, Option[] options) {
        StringBuilder str = new StringBuilder("Exception while invoking ");
        str.append((Object)method).append(' ');
        if (username != null) {
            str.append(username).append('@');
        }
        str.append(protocol.name().toLowerCase()).append("://");
        str.append(host);
        if (port > 0) {
            str.append(':').append(port);
        }
        if (!path.isEmpty() && !path.equals("/")) {
            if (!path.startsWith("/")) {
                str.append('/');
            }
            str.append(path);
        }
        Param[] params = (Param[])Stream.of(options).filter(Objects::nonNull).filter(o -> o.getType() == Option.Type.PARAM).filter(Param.class::isInstance).map(Param.class::cast).toArray(Param[]::new);
        if (params.length > 0) {
            str.append(Arrays.stream(params).map(AbstractOption::toString).collect(Collectors.joining("&", "?", "")));
        }
        return str.toString();
    }
}

