/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.rest;

import com.speedment.common.json.Json;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public final class Response {
    private final int status;
    private final String text;
    private final Map<String, List<String>> headers;

    public Response(int status, String text, Map<String, List<String>> headers) {
        this.status = status;
        this.text = Objects.requireNonNull(text);
        this.headers = Objects.requireNonNull(headers);
    }

    public int getStatus() {
        return this.status;
    }

    public String getText() {
        return this.text;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public boolean success() {
        switch (this.status) {
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: {
                return true;
            }
        }
        return false;
    }

    public Optional<Object> decodeJson() {
        if (!this.success()) {
            return Optional.empty();
        }
        return Optional.ofNullable(Json.fromJson((String)this.text));
    }

    public Stream<Object> decodeJsonArray() {
        Collection results = (Collection)Json.fromJson((String)this.text);
        return results.stream();
    }
}

