/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.json.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class JsonSerializer {
    private final OutputStream out;
    private final boolean pretty;
    private final int tabSize;
    private int level = 0;
    private static final int BEGIN_OBJECT = 123;
    private static final int END_OBJECT = 125;
    private static final int BEGIN_ARRAY = 91;
    private static final int END_ARRAY = 93;
    private static final int BEGIN_STRING = 34;
    private static final int END_STRING = 34;
    private static final int ASSIGN = 58;
    private static final int SEPARATOR = 44;
    private static final int NEW_LINE = 10;
    private static final int SPACE = 32;
    private static final int PRETTY_TAB_SIZE = 2;

    public JsonSerializer(OutputStream out, boolean pretty) {
        this.out = Objects.requireNonNull(out);
        this.pretty = pretty;
        this.tabSize = pretty ? 2 : 0;
    }

    public void print(Object unknown) throws IOException {
        if (unknown == null) {
            this.printNull();
        } else {
            Class<?> type = unknown.getClass();
            if (type == String.class) {
                this.printString((String)unknown);
            } else if (List.class.isAssignableFrom(type)) {
                List list = (List)unknown;
                this.printList(list);
            } else if (Map.class.isAssignableFrom(type)) {
                Map map = (Map)unknown;
                this.printMap(map);
            } else if (type == Double.class) {
                this.printDouble((Double)unknown);
            } else if (type == Float.class) {
                this.printDouble(((Float)unknown).doubleValue());
            } else if (type == Long.class) {
                this.printLong((Long)unknown);
            } else if (type == Integer.class) {
                this.printLong(((Integer)unknown).longValue());
            } else if (type == Short.class) {
                this.printLong(((Short)unknown).longValue());
            } else if (type == Byte.class) {
                this.printLong(((Byte)unknown).longValue());
            } else if (type == Boolean.class) {
                this.printBoolean((Boolean)unknown);
            } else {
                throw new IllegalArgumentException("Can't parse unsupported type '" + type + "' into JSON.");
            }
        }
    }

    private void printMap(Map<String, Object> map) throws IOException {
        this.out.write(123);
        ++this.level;
        boolean first = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                this.out.write(44);
            }
            if (this.pretty) {
                this.out.write(10);
                this.printIndent();
            }
            this.printString(entry.getKey());
            if (this.pretty) {
                this.out.write(32);
            }
            this.out.write(58);
            if (this.pretty) {
                this.out.write(32);
            }
            this.print(entry.getValue());
        }
        --this.level;
        if (this.pretty && !first) {
            this.out.write(10);
            this.printIndent();
        }
        this.out.write(125);
    }

    private void printList(List<Object> list) throws IOException {
        this.out.write(91);
        ++this.level;
        boolean first = true;
        for (Object object : list) {
            if (first) {
                first = false;
            } else {
                this.out.write(44);
            }
            if (this.pretty) {
                this.out.write(10);
                this.printIndent();
            }
            this.print(object);
        }
        --this.level;
        if (this.pretty && !first) {
            this.out.write(10);
            this.printIndent();
        }
        this.out.write(93);
    }

    private void printString(String string) throws IOException {
        this.out.write(34);
        this.out.write(string.replace("\"", "\\\"").getBytes());
        this.out.write(34);
    }

    private void printDouble(Double number) throws IOException {
        this.out.write(Double.toString(number).getBytes());
    }

    private void printLong(Long number) throws IOException {
        this.out.write(Long.toString(number).getBytes());
    }

    private void printBoolean(Boolean bool) throws IOException {
        if (bool.booleanValue()) {
            this.out.write("true".getBytes());
        } else {
            this.out.write("false".getBytes());
        }
    }

    private void printNull() throws IOException {
        this.out.write(110);
        this.out.write(117);
        this.out.write(108);
        this.out.write(108);
    }

    private void printIndent() throws IOException {
        int count = this.tabSize * this.level;
        for (int i = 0; i < count; ++i) {
            this.out.write(32);
        }
    }
}

