/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.model;

import com.speedment.common.codegen.internal.model.value.AnonymousValueImpl;
import com.speedment.common.codegen.internal.model.value.ArrayValueImpl;
import com.speedment.common.codegen.internal.model.value.BooleanValueImpl;
import com.speedment.common.codegen.internal.model.value.EnumValueImpl;
import com.speedment.common.codegen.internal.model.value.InvocationValueImpl;
import com.speedment.common.codegen.internal.model.value.NullValueImpl;
import com.speedment.common.codegen.internal.model.value.NumberValueImpl;
import com.speedment.common.codegen.internal.model.value.ReferenceValueImpl;
import com.speedment.common.codegen.internal.model.value.TextValueImpl;
import com.speedment.common.codegen.model.trait.HasCopy;
import com.speedment.common.codegen.model.value.AnonymousValue;
import com.speedment.common.codegen.model.value.ArrayValue;
import com.speedment.common.codegen.model.value.BooleanValue;
import com.speedment.common.codegen.model.value.EnumValue;
import com.speedment.common.codegen.model.value.InvocationValue;
import com.speedment.common.codegen.model.value.NullValue;
import com.speedment.common.codegen.model.value.NumberValue;
import com.speedment.common.codegen.model.value.ReferenceValue;
import com.speedment.common.codegen.model.value.TextValue;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Stream;

public interface Value<V>
extends HasCopy<Value<V>> {
    public Value<V> setValue(V var1);

    public V getValue();

    public static ArrayValue ofArray() {
        return new ArrayValueImpl();
    }

    public static ArrayValue ofArray(List<Value<?>> values) {
        return new ArrayValueImpl(values);
    }

    public static BooleanValue ofBoolean(Boolean val) {
        return new BooleanValueImpl(val);
    }

    public static EnumValue ofEnum(Type type, String constant) {
        return new EnumValueImpl(type, constant);
    }

    public static NullValue ofNull() {
        return new NullValueImpl();
    }

    public static NumberValue ofNumber(Number num) {
        return new NumberValueImpl(num);
    }

    public static ReferenceValue ofReference(String reference) {
        return new ReferenceValueImpl(reference);
    }

    public static TextValue ofText(String text) {
        return new TextValueImpl(text);
    }

    public static AnonymousValue ofAnonymous(Type implementedType) {
        return new AnonymousValueImpl().setValue(implementedType);
    }

    public static InvocationValue ofInvocation(String method, Value<?> ... args) {
        InvocationValue result = new InvocationValueImpl().setValue(method);
        Stream.of(args).forEachOrdered(result::add);
        return result;
    }

    public static InvocationValue ofInvocation(Type owner, String method, Value<?> ... args) {
        InvocationValue result = new InvocationValueImpl().set(owner).setValue(method);
        Stream.of(args).forEachOrdered(result::add);
        return result;
    }
}

