/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.model;

import com.speedment.common.codegen.internal.model.HashUtil;
import com.speedment.common.codegen.internal.util.Copier;
import com.speedment.common.codegen.model.AnnotationUsage;
import com.speedment.common.codegen.model.Field;
import com.speedment.common.codegen.model.Generic;
import com.speedment.common.codegen.model.Import;
import com.speedment.common.codegen.model.Javadoc;
import com.speedment.common.codegen.model.Method;
import com.speedment.common.codegen.model.modifier.Modifier;
import com.speedment.common.codegen.model.trait.HasMethods;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class MethodImpl
implements Method {
    private HasMethods<?> parent;
    private String name;
    private Type type;
    private Javadoc javadoc;
    private final List<AnnotationUsage> annotations;
    private final List<Import> imports;
    private final List<Generic> generics;
    private final List<Field> params;
    private final List<String> code;
    private final Set<Modifier> modifiers;
    private final Set<Type> exceptions;

    public MethodImpl(String name, Type type) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.javadoc = null;
        this.annotations = new ArrayList<AnnotationUsage>();
        this.imports = new ArrayList<Import>();
        this.generics = new ArrayList<Generic>();
        this.params = new ArrayList<Field>();
        this.code = new ArrayList<String>();
        this.modifiers = EnumSet.noneOf(Modifier.class);
        this.exceptions = new HashSet<Type>();
    }

    protected MethodImpl(Method prototype) {
        this.parent = prototype.getParent().orElse(null);
        this.name = Objects.requireNonNull(prototype).getName();
        this.type = Objects.requireNonNull(prototype.getType());
        this.javadoc = prototype.getJavadoc().map(Copier::copy).orElse(null);
        this.annotations = Copier.copy(prototype.getAnnotations());
        this.imports = Copier.copy(prototype.getImports());
        this.generics = Copier.copy(prototype.getGenerics());
        this.params = Copier.copy(prototype.getFields());
        this.code = Copier.copy(prototype.getCode(), s -> s);
        this.modifiers = Copier.copy(prototype.getModifiers(), Modifier::copy, EnumSet.noneOf(Modifier.class));
        this.exceptions = new HashSet<Type>(prototype.getExceptions());
    }

    @Override
    public Method setParent(HasMethods<?> parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public Optional<HasMethods<?>> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Method setName(String name) {
        this.name = Objects.requireNonNull(name);
        return this;
    }

    @Override
    public List<Import> getImports() {
        return this.imports;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Method set(Type type) {
        this.type = Objects.requireNonNull(type);
        return this;
    }

    @Override
    public List<Field> getFields() {
        return this.params;
    }

    @Override
    public List<String> getCode() {
        return this.code;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public Method set(Javadoc doc) {
        this.javadoc = (Javadoc)doc.setParent(this);
        return this;
    }

    @Override
    public Optional<Javadoc> getJavadoc() {
        return Optional.ofNullable(this.javadoc);
    }

    @Override
    public List<AnnotationUsage> getAnnotations() {
        return this.annotations;
    }

    @Override
    public List<Generic> getGenerics() {
        return this.generics;
    }

    @Override
    public Set<Type> getExceptions() {
        return this.exceptions;
    }

    @Override
    public MethodImpl copy() {
        return new MethodImpl(this);
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + HashUtil.identityHashForParent(this);
        hash = 71 * hash + Objects.hashCode(this.name);
        hash = 71 * hash + Objects.hashCode(this.type);
        hash = 71 * hash + Objects.hashCode(this.javadoc);
        hash = 71 * hash + Objects.hashCode(this.annotations);
        hash = 71 * hash + Objects.hashCode(this.imports);
        hash = 71 * hash + Objects.hashCode(this.generics);
        hash = 71 * hash + Objects.hashCode(this.params);
        hash = 71 * hash + Objects.hashCode(this.code);
        hash = 71 * hash + Objects.hashCode(this.modifiers);
        hash = 71 * hash + Objects.hashCode(this.exceptions);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodImpl other = (MethodImpl)obj;
        if (!Objects.equals(this.parent, other.parent)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.javadoc, other.javadoc)) {
            return false;
        }
        if (!Objects.equals(this.annotations, other.annotations)) {
            return false;
        }
        if (!Objects.equals(this.imports, other.imports)) {
            return false;
        }
        if (!Objects.equals(this.generics, other.generics)) {
            return false;
        }
        if (!Objects.equals(this.params, other.params)) {
            return false;
        }
        if (!Objects.equals(this.code, other.code)) {
            return false;
        }
        if (!Objects.equals(this.modifiers, other.modifiers)) {
            return false;
        }
        return Objects.equals(this.exceptions, other.exceptions);
    }
}

