/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.model;

import com.speedment.common.codegen.internal.model.HashUtil;
import com.speedment.common.codegen.internal.util.Copier;
import com.speedment.common.codegen.model.Import;
import com.speedment.common.codegen.model.Initializer;
import com.speedment.common.codegen.model.modifier.Modifier;
import com.speedment.common.codegen.model.trait.HasInitializers;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class InitializerImpl
implements Initializer {
    private HasInitializers<?> parent;
    private final List<Import> imports;
    private final List<String> code;
    private final Set<Modifier> modifiers;

    public InitializerImpl() {
        this.code = new ArrayList<String>();
        this.imports = new ArrayList<Import>();
        this.modifiers = EnumSet.noneOf(Modifier.class);
    }

    protected InitializerImpl(Initializer prototype) {
        Objects.requireNonNull(prototype);
        this.code = Copier.copy(prototype.getCode(), c -> c);
        this.imports = Copier.copy(prototype.getImports());
        this.modifiers = Copier.copy(prototype.getModifiers(), c -> c);
    }

    @Override
    public Initializer setParent(HasInitializers<?> parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public Optional<HasInitializers<?>> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public List<Import> getImports() {
        return this.imports;
    }

    @Override
    public List<String> getCode() {
        return this.code;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public InitializerImpl copy() {
        return new InitializerImpl(this);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + HashUtil.identityHashForParent(this);
        hash = 67 * hash + Objects.hashCode(this.imports);
        hash = 67 * hash + Objects.hashCode(this.code);
        hash = 67 * hash + Objects.hashCode(this.modifiers);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InitializerImpl other = (InitializerImpl)obj;
        if (!Objects.equals(this.parent, other.parent)) {
            return false;
        }
        if (!Objects.equals(this.imports, other.imports)) {
            return false;
        }
        if (!Objects.equals(this.code, other.code)) {
            return false;
        }
        return Objects.equals(this.modifiers, other.modifiers);
    }
}

