/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.model;

import com.speedment.common.codegen.constant.SimpleType;
import com.speedment.common.codegen.internal.util.NullUtil;
import com.speedment.common.codegen.model.Generic;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class GenericImpl
implements Generic {
    private String lowerBound;
    private final List<Type> upperBounds;
    private Generic.BoundType type = Generic.BoundType.EXTENDS;

    public GenericImpl() {
        this.lowerBound = null;
        this.upperBounds = new ArrayList<Type>();
    }

    public GenericImpl(String lowerBound) {
        this(lowerBound, new Type[0]);
    }

    public GenericImpl(Type ... upperBounds) {
        this((String)null, NullUtil.requireNonNullElements(upperBounds));
    }

    public GenericImpl(String lowerBound, Type ... upperBounds) {
        NullUtil.requireNonNullElements(upperBounds);
        this.lowerBound = lowerBound;
        this.upperBounds = Arrays.asList(upperBounds);
    }

    protected GenericImpl(Generic prototype) {
        this.lowerBound = prototype.getLowerBound().orElse(null);
        this.upperBounds = new ArrayList<Type>(prototype.getUpperBounds());
    }

    @Override
    public Generic setLowerBound(String lowerBound) {
        this.lowerBound = lowerBound;
        return this;
    }

    @Override
    public Optional<String> getLowerBound() {
        return Optional.ofNullable(this.lowerBound);
    }

    @Override
    public Generic setBoundType(Generic.BoundType type) {
        this.type = type;
        return this;
    }

    @Override
    public Generic.BoundType getBoundType() {
        return this.type;
    }

    @Override
    public List<Type> getUpperBounds() {
        return this.upperBounds;
    }

    @Override
    public Type asType() {
        if (this.lowerBound == null || "?".equals(this.lowerBound)) {
            if (this.upperBounds.isEmpty()) {
                throw new UnsupportedOperationException("This generic has neither lower or upper bound, so it can't be parsed into a Type.");
            }
            if (this.upperBounds.size() > 1) {
                throw new UnsupportedOperationException("Since no lowerBound is specified, this Generic needs exactly one upper bound for a Type to be parsed. Instead, it has " + this.upperBounds);
            }
            return this.upperBounds.get(0);
        }
        return SimpleType.create(this.lowerBound);
    }

    @Override
    public GenericImpl copy() {
        return new GenericImpl(this);
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + Objects.hashCode(this.lowerBound);
        hash = 89 * hash + Objects.hashCode(this.upperBounds);
        hash = 89 * hash + Objects.hashCode((Object)this.type);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericImpl other = (GenericImpl)obj;
        if (!Objects.equals(this.lowerBound, other.lowerBound)) {
            return false;
        }
        if (!Objects.equals(this.upperBounds, other.upperBounds)) {
            return false;
        }
        return this.type == other.type;
    }
}

