/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.model;

import com.speedment.common.codegen.internal.util.Copier;
import com.speedment.common.codegen.model.Annotation;
import com.speedment.common.codegen.model.AnnotationUsage;
import com.speedment.common.codegen.model.Field;
import com.speedment.common.codegen.model.Import;
import com.speedment.common.codegen.model.Javadoc;
import com.speedment.common.codegen.model.modifier.Modifier;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class AnnotationImpl
implements Annotation {
    private String name;
    private Javadoc javadoc;
    private final List<AnnotationUsage> annotations;
    private final List<Field> fields;
    private final List<Import> imports;
    private final Set<Modifier> modifiers;

    public AnnotationImpl(String name) {
        this.name = Objects.requireNonNull(name);
        this.javadoc = null;
        this.annotations = new ArrayList<AnnotationUsage>();
        this.fields = new ArrayList<Field>();
        this.imports = new ArrayList<Import>();
        this.modifiers = EnumSet.noneOf(Modifier.class);
    }

    protected AnnotationImpl(Annotation prototype) {
        Objects.requireNonNull(prototype);
        this.name = prototype.getName();
        this.javadoc = prototype.getJavadoc().map(Copier::copy).orElse(null);
        this.annotations = Copier.copy(prototype.getAnnotations());
        this.fields = Copier.copy(prototype.getFields());
        this.imports = Copier.copy(prototype.getImports());
        this.modifiers = Copier.copy(prototype.getModifiers(), Modifier::copy, EnumSet.noneOf(Modifier.class));
    }

    @Override
    public Annotation setName(String name) {
        this.name = Objects.requireNonNull(name);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public Annotation set(Javadoc doc) {
        this.javadoc = (Javadoc)doc.setParent(this);
        return this;
    }

    @Override
    public Optional<Javadoc> getJavadoc() {
        return Optional.ofNullable(this.javadoc);
    }

    @Override
    public List<Import> getImports() {
        return this.imports;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public List<AnnotationUsage> getAnnotations() {
        return this.annotations;
    }

    @Override
    public AnnotationImpl copy() {
        return new AnnotationImpl(this);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.name);
        hash = 41 * hash + Objects.hashCode(this.javadoc);
        hash = 41 * hash + Objects.hashCode(this.annotations);
        hash = 41 * hash + Objects.hashCode(this.fields);
        hash = 41 * hash + Objects.hashCode(this.imports);
        hash = 41 * hash + Objects.hashCode(this.modifiers);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationImpl other = (AnnotationImpl)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.javadoc, other.javadoc)) {
            return false;
        }
        if (!Objects.equals(this.annotations, other.annotations)) {
            return false;
        }
        if (!Objects.equals(this.fields, other.fields)) {
            return false;
        }
        if (!Objects.equals(this.imports, other.imports)) {
            return false;
        }
        return Objects.equals(this.modifiers, other.modifiers);
    }
}

