/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.internal.java;

import com.speedment.common.codegen.DependencyManager;
import com.speedment.common.codegen.Generator;
import com.speedment.common.codegen.Meta;
import com.speedment.common.codegen.RenderStack;
import com.speedment.common.codegen.Transform;
import com.speedment.common.codegen.TransformFactory;
import com.speedment.common.codegen.internal.java.JavaTransformFactory;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JavaGenerator
implements Generator {
    private static final Pattern[] IGNORED = JavaGenerator.compileAll("^void$", "^byte$", "^short$", "^char$", "^int$", "^long$", "^boolean$", "^float$", "^double$", "^java\\.lang\\.[^\\.]+$");
    private final Generator inner;

    public JavaGenerator() {
        this(new JavaTransformFactory());
    }

    public JavaGenerator(TransformFactory factory) {
        this.inner = Generator.create(DependencyManager.create(IGNORED), factory);
    }

    @Override
    public DependencyManager getDependencyMgr() {
        return this.inner.getDependencyMgr();
    }

    @Override
    public RenderStack getRenderStack() {
        return this.inner.getRenderStack();
    }

    @Override
    public <A, B> Stream<Meta<A, B>> metaOn(A from, Class<B> to) {
        return this.inner.metaOn(from, to);
    }

    @Override
    public <A, B> Stream<Meta<A, B>> metaOn(A from, Class<B> to, Class<? extends Transform<A, B>> transform) {
        return this.inner.metaOn(from, to, transform);
    }

    @Override
    public <M> Stream<Meta<M, String>> metaOn(M model) {
        return this.inner.metaOn(model);
    }

    @Override
    public <A> Stream<Meta<A, String>> metaOn(Collection<A> models) {
        return this.inner.metaOn(models);
    }

    @Override
    public <A, B> Stream<Meta<A, B>> metaOn(Collection<A> models, Class<B> to) {
        return this.inner.metaOn(models, to);
    }

    @Override
    public <A, B> Stream<Meta<A, B>> metaOn(Collection<A> models, Class<B> to, Class<? extends Transform<A, B>> transform) {
        return this.inner.metaOn(models, to, transform);
    }

    @Override
    public Optional<String> on(Object model) {
        return this.inner.on(model);
    }

    @Override
    public <M> Stream<String> onEach(Collection<M> models) {
        return this.inner.onEach(models);
    }

    @Override
    public <A, B> Optional<Meta<A, B>> transform(Transform<A, B> transform, A model, TransformFactory factory) {
        return this.inner.transform(transform, model, factory);
    }

    public static Generator create(DependencyManager mgr, TransformFactory factory) {
        return Generator.create(mgr, factory);
    }

    private static Pattern[] compileAll(String ... regexp) {
        Set<Pattern> patterns = Stream.of(regexp).map(Pattern::compile).collect(Collectors.toSet());
        return patterns.toArray(new Pattern[patterns.size()]);
    }
}

