/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.controller;

import com.speedment.common.codegen.constant.DefaultJavadocTag;
import com.speedment.common.codegen.model.ClassOrInterface;
import com.speedment.common.codegen.model.Javadoc;
import com.speedment.common.codegen.model.JavadocTag;
import com.speedment.common.codegen.model.Method;
import com.speedment.common.codegen.model.trait.HasClasses;
import com.speedment.common.codegen.model.trait.HasConstructors;
import com.speedment.common.codegen.model.trait.HasFields;
import com.speedment.common.codegen.model.trait.HasGenerics;
import com.speedment.common.codegen.model.trait.HasJavadoc;
import com.speedment.common.codegen.model.trait.HasMethods;
import java.util.Objects;
import java.util.function.Consumer;

public final class AutoJavadoc<T extends HasJavadoc<?>>
implements Consumer<T> {
    private static final String DEFAULT_TEXT = "Write some documentation here.";
    private static final String DEFAULT_NAME = "Your Name";

    @Override
    public void accept(T model) {
        AutoJavadoc.createJavadoc((HasJavadoc)Objects.requireNonNull(model));
    }

    private static <T extends HasJavadoc<?>> void createJavadoc(T model) {
        Javadoc doc = Objects.requireNonNull(model).getJavadoc().orElse(Javadoc.of(DEFAULT_TEXT));
        model.set(doc);
        if (model instanceof HasGenerics) {
            ((HasGenerics)((Object)model)).getGenerics().forEach(g -> g.getLowerBound().ifPresent(t -> AutoJavadoc.addTag(doc, DefaultJavadocTag.PARAM.setValue("<" + t + ">"))));
        }
        if (model instanceof ClassOrInterface) {
            doc.add(DefaultJavadocTag.AUTHOR.setValue(DEFAULT_NAME));
        } else if (model instanceof HasFields) {
            ((HasFields)((Object)model)).getFields().forEach(f -> AutoJavadoc.addTag(doc, DefaultJavadocTag.PARAM.setValue(f.getName())));
        }
        if (model instanceof Method && ((Method)model).getType() != Void.TYPE) {
            AutoJavadoc.addTag(doc, DefaultJavadocTag.RETURN);
        }
        if (model instanceof HasConstructors) {
            ((HasConstructors)((Object)model)).getConstructors().forEach(AutoJavadoc::createJavadoc);
        }
        if (model instanceof HasMethods) {
            ((HasMethods)((Object)model)).getMethods().forEach(AutoJavadoc::createJavadoc);
        }
        if (model instanceof HasClasses) {
            ((HasClasses)((Object)model)).getClasses().forEach(AutoJavadoc::createJavadoc);
        }
    }

    private static void addTag(Javadoc doc, JavadocTag tag) {
        if (!AutoJavadoc.hasTagAlready(Objects.requireNonNull(doc), Objects.requireNonNull(tag))) {
            doc.add(tag);
        }
    }

    private static boolean hasTagAlready(Javadoc doc, JavadocTag tag) {
        Objects.requireNonNull(doc);
        Objects.requireNonNull(tag);
        return doc.getTags().stream().anyMatch(t -> tag.getName().equals(t.getName()) && tag.getValue().equals(t.getValue()));
    }
}

