/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.controller;

import com.speedment.common.codegen.DependencyManager;
import com.speedment.common.codegen.model.Enum;
import com.speedment.common.codegen.model.File;
import com.speedment.common.codegen.model.Import;
import com.speedment.common.codegen.model.trait.HasAnnotationUsage;
import com.speedment.common.codegen.model.trait.HasClasses;
import com.speedment.common.codegen.model.trait.HasConstructors;
import com.speedment.common.codegen.model.trait.HasFields;
import com.speedment.common.codegen.model.trait.HasGenerics;
import com.speedment.common.codegen.model.trait.HasImplements;
import com.speedment.common.codegen.model.trait.HasMethods;
import com.speedment.common.codegen.model.trait.HasSupertype;
import com.speedment.common.codegen.model.trait.HasThrows;
import com.speedment.common.codegen.model.trait.HasType;
import com.speedment.common.codegen.model.trait.HasValue;
import com.speedment.common.codegen.model.trait.HasValues;
import com.speedment.common.codegen.model.value.AnonymousValue;
import com.speedment.common.codegen.util.Formatting;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public final class AutoImports
implements Consumer<File> {
    private final DependencyManager mgr;

    public AutoImports(DependencyManager mgr) {
        this.mgr = Objects.requireNonNull(mgr);
    }

    @Override
    public void accept(File file) {
        this.findTypesIn(Objects.requireNonNull(file)).forEach((s, t) -> file.add(Import.of(t)));
    }

    private Map<String, Type> findTypesIn(Object model) {
        HashMap<String, Type> map = new HashMap<String, Type>();
        this.findTypesIn(Objects.requireNonNull(model), map);
        return map;
    }

    private void findTypesIn(Object model, Map<String, Type> types) {
        Objects.requireNonNull(model);
        Objects.requireNonNull(types);
        if (model instanceof HasSupertype) {
            ((HasSupertype)model).getSupertype().ifPresent(t -> this.addType((Type)t, types));
        }
        if (model instanceof HasAnnotationUsage) {
            ((HasAnnotationUsage)model).getAnnotations().forEach(a -> {
                this.addType(a.getType(), types);
                a.getValue().ifPresent(v -> this.findTypesIn(v, types));
                a.getValues().stream().map(Map.Entry::getValue).forEach(v -> this.findTypesIn(v, types));
            });
        }
        if (model instanceof HasClasses) {
            ((HasClasses)model).getClasses().forEach(c -> this.findTypesIn(c, types));
        }
        if (model instanceof HasConstructors) {
            ((HasConstructors)model).getConstructors().forEach(c -> this.findTypesIn(c, types));
        }
        if (model instanceof HasFields) {
            ((HasFields)model).getFields().forEach(f -> {
                this.addType(f.getType(), types);
                this.findTypesIn(f, types);
            });
        }
        if (model instanceof HasGenerics) {
            ((HasGenerics)model).getGenerics().forEach(g -> g.getUpperBounds().forEach(ub -> this.addType((Type)ub, types)));
        }
        if (model instanceof HasImplements) {
            ((HasImplements)model).getInterfaces().forEach(i -> this.addType((Type)i, types));
        }
        if (model instanceof HasMethods) {
            ((HasMethods)model).getMethods().forEach(m -> {
                this.addType(m.getType(), types);
                this.findTypesIn(m, types);
            });
        }
        if (model instanceof HasThrows) {
            ((HasThrows)model).getExceptions().forEach(e -> this.addType((Type)e, types));
        }
        if (model instanceof HasType) {
            this.addType(((HasType)model).getType(), types);
        }
        if (model instanceof AnonymousValue) {
            ((AnonymousValue)model).getTypeParameters().forEach(e -> this.addType((Type)e, types));
        }
        if (model instanceof HasValues) {
            ((HasValues)model).getValues().forEach(v -> this.findTypesIn(v, types));
        }
        if (model instanceof HasValue) {
            ((HasValue)model).getValue().ifPresent(val -> this.findTypesIn(val, types));
        }
        if (model instanceof Enum) {
            ((Enum)model).getConstants().forEach(ec -> this.findTypesIn(ec, types));
        }
    }

    private void addType(Type type, Map<String, Type> types) {
        ParameterizedType generic;
        Objects.requireNonNull(type);
        Objects.requireNonNull(types);
        String name = type.getTypeName();
        if (name.contains("<")) {
            name = name.substring(0, name.indexOf(60));
        }
        if (name.contains("[")) {
            name = name.substring(0, name.indexOf(91));
        }
        if (name.contains(".") && !this.mgr.isIgnored(name)) {
            String shortName = Formatting.shortName(name);
            if (types.keySet().stream().map(Formatting::shortName).noneMatch(shortName::equals)) {
                types.put(name, type);
            }
        }
        if (type instanceof ParameterizedType && (generic = (ParameterizedType)type).getActualTypeArguments().length > 0) {
            this.findTypesIn(type, types);
            for (Type genType : generic.getActualTypeArguments()) {
                this.addType(genType, types);
            }
        }
    }
}

