/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.common.codegen.constant;

import com.speedment.common.codegen.constant.SimpleType;
import com.speedment.common.codegen.constant.SimpleTypeUtil;
import com.speedment.common.codegen.model.ClassOrInterface;
import com.speedment.common.codegen.model.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;

public final class SimpleParameterizedType
implements ParameterizedType {
    private final String fullName;
    private final Type[] parameters;

    public static SimpleParameterizedType create(Type mainType, Type ... parameters) {
        return SimpleParameterizedType.create(mainType.getTypeName(), parameters);
    }

    public static SimpleParameterizedType create(String fullName, Type ... parameters) {
        return new SimpleParameterizedType(fullName, parameters);
    }

    public static SimpleParameterizedType create(File file, ClassOrInterface<?> clazz, Type ... parameters) {
        return SimpleParameterizedType.create(SimpleTypeUtil.nameOf(file, clazz), parameters);
    }

    @Override
    public Type[] getActualTypeArguments() {
        return Arrays.copyOf(this.parameters, this.parameters.length);
    }

    @Override
    public Type getRawType() {
        return SimpleType.create(this.fullName);
    }

    @Override
    public Type getOwnerType() {
        throw new UnsupportedOperationException("Owner types are currently not supported by CodeGen.");
    }

    @Override
    public String getTypeName() {
        return this.fullName;
    }

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.fullName);
        hash = 29 * hash + Arrays.deepHashCode(this.parameters);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType other = (ParameterizedType)obj;
        return Objects.equals(this.fullName, other.getTypeName()) && Arrays.deepEquals(this.parameters, other.getActualTypeArguments());
    }

    public String toString() {
        return this.getTypeName();
    }

    private SimpleParameterizedType(String fullName, Type[] parameters) {
        this.fullName = Objects.requireNonNull(fullName);
        this.parameters = Objects.requireNonNull(parameters);
    }
}

