/*
 * Decompiled with CFR 0.152.
 */
package com.android.generalextensionlibrary.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\u001a\"\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a&\u0010\u0006\u001a\u0004\u0018\u00010\u00022\b\u0010\u0004\u001a\u0004\u0018\u00010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002\u001a&\u0010\b\u001a\u0004\u0018\u00010\u00022\b\u0010\u0004\u001a\u0004\u0018\u00010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002\u001a)\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\n2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\u000b\u001a\u0010\u0010\f\u001a\u00020\r2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\u000e\u001a\u00020\r2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\u000f\u001a\u00020\r2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\u0010\u001a\u00020\r2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u001a\u0010\u0011\u001a\u00020\r2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\u0012\u001a\u00020\r2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\u0013\u001a\u00020\r2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\u0014\u001a\u00020\r2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\u0015\u001a\u00020\r2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0010\u0010\u0016\u001a\u00020\r2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\u0017"}, d2={"getMatches", "", "", "regex", "input", "", "getReplaceAll", "replacement", "getReplaceFirst", "getSplits", "", "(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "isDate", "", "isEmail", "isIDCard", "isIP", "isMatch", "isMobile", "isTelephone", "isURL", "isUsername", "isZh", "commonlibrary_release"})
public final class RegularUtilKt {
    public static final boolean isMobile(@Nullable CharSequence input) {
        return RegularUtilKt.isMatch("^((13[0-9])|(14[5,7])|(15[0-3,5-9])|(17[0,3,5-8])|(18[0-9])|(147))\\d{8}$", input);
    }

    public static final boolean isTelephone(@Nullable CharSequence input) {
        return RegularUtilKt.isMatch("^0\\d{2,3}[- ]?\\d{7,8}", input);
    }

    public static final boolean isIDCard(@Nullable CharSequence input) {
        String string = String.valueOf(input);
        String string2 = "(^\\d{15}$)|(^\\d{17}([0-9]|X)$)";
        boolean bl = false;
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
        String string5 = string4;
        return RegularUtilKt.isMatch(string2, string5);
    }

    public static final boolean isEmail(@Nullable CharSequence input) {
        return RegularUtilKt.isMatch("^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$", input);
    }

    public static final boolean isURL(@Nullable CharSequence input) {
        return RegularUtilKt.isMatch("[a-zA-z]+://[^\\s]*", input);
    }

    public static final boolean isZh(@Nullable CharSequence input) {
        return RegularUtilKt.isMatch("^[\\u4e00-\\u9fa5]+$", input);
    }

    public static final boolean isUsername(@Nullable CharSequence input) {
        return RegularUtilKt.isMatch("^[\\w\\u4e00-\\u9fa5]{6,20}(?<!_)$", input);
    }

    public static final boolean isDate(@Nullable CharSequence input) {
        return RegularUtilKt.isMatch("^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$", input);
    }

    public static final boolean isIP(@Nullable CharSequence input) {
        return RegularUtilKt.isMatch("((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)", input);
    }

    public static final boolean isMatch(@Nullable String regex, @Nullable CharSequence input) {
        return input != null && input.length() > 0 && Pattern.matches(regex, input);
    }

    @Nullable
    public static final List<String> getMatches(@Nullable String regex, @Nullable CharSequence input) {
        if (input == null) {
            return null;
        }
        List matches = new ArrayList();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            String string = matcher.group();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"matcher.group()");
            matches.add(string);
        }
        return matches;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final String[] getSplits(@Nullable String input, @Nullable String regex) {
        String string = input;
        Object object = string;
        if (string == null) return null;
        CharSequence charSequence = (CharSequence)object;
        String[] stringArray = new String[1];
        String string2 = regex;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        stringArray[0] = string2;
        List list = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        object = list;
        if (list == null) return null;
        Collection $this$toTypedArray$iv = (Collection)object;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray3 = stringArray2;
        return stringArray3;
    }

    @Nullable
    public static final String getReplaceFirst(@Nullable String input, @Nullable String regex, @Nullable String replacement) {
        return input == null ? null : Pattern.compile(regex).matcher(input).replaceFirst(replacement);
    }

    @Nullable
    public static final String getReplaceAll(@Nullable String input, @Nullable String regex, @Nullable String replacement) {
        return input == null ? null : Pattern.compile(regex).matcher(input).replaceAll(replacement);
    }
}

