/*
 * Decompiled with CFR 0.152.
 */
package com.android.generalextensionlibrary.util;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.core.content.FileProvider;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ2\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lcom/android/generalextensionlibrary/util/PermissionUtil;", "", "()V", "getUriForFile", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "file", "Ljava/io/File;", "getUriForFile24", "installIntent", "", "filePath", "", "setIntentDataAndType", "intent", "Landroid/content/Intent;", "type", "writeAble", "", "commonlibrary_release"})
public final class PermissionUtil {
    public static final PermissionUtil INSTANCE;

    @Nullable
    public final Uri getUriForFile(@NotNull Context context, @Nullable File file) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Uri fileUri = null;
        fileUri = Build.VERSION.SDK_INT >= 24 ? this.getUriForFile24(context, file) : Uri.fromFile((File)file);
        return fileUri;
    }

    @NotNull
    public final Uri getUriForFile24(@NotNull Context context, @Nullable File file) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = context.getPackageName() + ".android7.fileprovider";
        File file2 = file;
        if (file2 == null) {
            Intrinsics.throwNpe();
        }
        Uri uri = FileProvider.getUriForFile((Context)context, (String)string, (File)file2);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"FileProvider.getUriForFi\u2026d7.fileprovider\", file!!)");
        return uri;
    }

    public final void setIntentDataAndType(@NotNull Context context, @NotNull Intent intent, @Nullable String type, @Nullable File file, boolean writeAble) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        if (Build.VERSION.SDK_INT >= 24) {
            intent.setDataAndType(this.getUriForFile(context, file), type);
            intent.addFlags(1);
            if (writeAble) {
                intent.addFlags(2);
            }
        } else {
            Intrinsics.checkExpressionValueIsNotNull((Object)intent.setDataAndType(Uri.fromFile((File)file), type), (String)"intent.setDataAndType(Uri.fromFile(file), type)");
        }
    }

    public final void installIntent(@NotNull Context context, @NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setFlags(0x10000000);
        INSTANCE.setIntentDataAndType(context, intent, "application/vnd.android.package-archive", new File(filePath), true);
        try {
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            e.printStackTrace();
        }
    }

    private PermissionUtil() {
    }

    static {
        PermissionUtil permissionUtil;
        INSTANCE = permissionUtil = new PermissionUtil();
    }
}

