/*
 * Decompiled with CFR 0.152.
 */
package com.android.generalextensionlibrary.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/android/generalextensionlibrary/util/NetworkUtil;", "", "()V", "Companion", "commonlibrary_release"})
public final class NetworkUtil {
    public static final int NETWORK_WIFI = 1;
    public static final int NETWORK_4G = 4;
    public static final int NETWORK_3G = 3;
    public static final int NETWORK_2G = 2;
    public static final int NETWORK_UNKNOWN = 5;
    public static final int NETWORK_NO = -1;
    private static final int NETWORK_TYPE_GSM = 16;
    private static final int NETWORK_TYPE_TD_SCDMA = 17;
    private static final int NETWORK_TYPE_IWLAN = 18;
    public static final Companion Companion = new Companion(null);

    private NetworkUtil() {
        throw (Throwable)new UnsupportedOperationException("NetworkUtils constructor not allowed to be created");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u000eJ\u0016\u0010 \u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/generalextensionlibrary/util/NetworkUtil$Companion;", "", "()V", "NETWORK_2G", "", "NETWORK_3G", "NETWORK_4G", "NETWORK_NO", "NETWORK_TYPE_GSM", "NETWORK_TYPE_IWLAN", "NETWORK_TYPE_TD_SCDMA", "NETWORK_UNKNOWN", "NETWORK_WIFI", "checkNetworkState", "", "context", "Landroid/content/Context;", "getActiveNetworkInfo", "Landroid/net/NetworkInfo;", "getNetworkOperatorName", "", "getNetworkType", "getNetworkTypeName", "is4G", "isConnected", "isNetworkAvailable", "isWifi", "isWifiConnected", "isWifiEnabled", "setDataEnabled", "", "enabled", "setWifiEnabled", "commonlibrary_release"})
    public static final class Companion {
        public final boolean checkNetworkState(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("connectivity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
            }
            ConnectivityManager manager = (ConnectivityManager)object;
            NetworkInfo info = manager.getActiveNetworkInfo();
            return info != null && info.isAvailable();
        }

        private final NetworkInfo getActiveNetworkInfo(Context context) {
            Object object = context.getSystemService("connectivity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
            }
            ConnectivityManager cm = (ConnectivityManager)object;
            NetworkInfo networkInfo = cm.getActiveNetworkInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)networkInfo, (String)"cm.activeNetworkInfo");
            return networkInfo;
        }

        public final void setDataEnabled(@NotNull Context context, boolean enabled) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            try {
                Method setMobileDataEnabledMethod;
                Object object = context.getSystemService("phone");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
                }
                TelephonyManager tm = (TelephonyManager)object;
                Method method = tm.getClass().getDeclaredMethod("setDataEnabled", Boolean.TYPE);
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"tm.javaClass.getDeclared\u2026ype\n                    )");
                Method method2 = setMobileDataEnabledMethod = method;
                if (method2 != null) {
                    method2.invoke((Object)tm, enabled);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public final boolean is4G(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            NetworkInfo info = this.getActiveNetworkInfo(context);
            return info != null && info.isAvailable() && info.getSubtype() == 13;
        }

        public final boolean isWifiEnabled(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("wifi");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.net.wifi.WifiManager");
            }
            WifiManager wifiManager = (WifiManager)object;
            return wifiManager.isWifiEnabled();
        }

        public final void setWifiEnabled(@NotNull Context context, boolean enabled) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("wifi");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.net.wifi.WifiManager");
            }
            WifiManager wifiManager = (WifiManager)object;
            if (enabled) {
                if (!wifiManager.isWifiEnabled()) {
                    wifiManager.setWifiEnabled(true);
                }
            } else if (wifiManager.isWifiEnabled()) {
                wifiManager.setWifiEnabled(false);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isWifiConnected(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("connectivity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
            }
            ConnectivityManager cm = (ConnectivityManager)object;
            if (cm == null) return false;
            if (cm.getActiveNetworkInfo() == null) return false;
            NetworkInfo networkInfo = cm.getActiveNetworkInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)networkInfo, (String)"cm.activeNetworkInfo");
            if (networkInfo.getType() != 1) return false;
            return true;
        }

        @Nullable
        public final String getNetworkOperatorName(@NotNull Context context) {
            TelephonyManager tm;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("phone");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
            }
            TelephonyManager telephonyManager = tm = (TelephonyManager)object;
            return telephonyManager != null ? telephonyManager.getNetworkOperatorName() : null;
        }

        public final int getNetworkType(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            int netType = -1;
            NetworkInfo info = this.getActiveNetworkInfo(context);
            if (info != null && info.isAvailable()) {
                int n;
                if (info.getType() == 1) {
                    n = 1;
                } else if (info.getType() == 0) {
                    switch (info.getSubtype()) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 11: 
                        case 16: {
                            n = 2;
                            break;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: 
                        case 17: {
                            n = 3;
                            break;
                        }
                        case 13: 
                        case 18: {
                            n = 4;
                            break;
                        }
                        default: {
                            String subtypeName = info.getSubtypeName();
                            if (StringsKt.equals((String)subtypeName, (String)"TD-SCDMA", (boolean)true) || StringsKt.equals((String)subtypeName, (String)"WCDMA", (boolean)true) || StringsKt.equals((String)subtypeName, (String)"CDMA2000", (boolean)true)) {
                                n = 3;
                                break;
                            }
                            n = 5;
                            break;
                        }
                    }
                } else {
                    n = 5;
                }
                netType = n;
            }
            return netType;
        }

        @NotNull
        public final String getNetworkTypeName(@NotNull Context context) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            switch (this.getNetworkType(context)) {
                case 1: {
                    string = "NETWORK_WIFI";
                    break;
                }
                case 4: {
                    string = "NETWORK_4G";
                    break;
                }
                case 3: {
                    string = "NETWORK_3G";
                    break;
                }
                case 2: {
                    string = "NETWORK_2G";
                    break;
                }
                case -1: {
                    string = "NETWORK_NO";
                    break;
                }
                default: {
                    string = "NETWORK_UNKNOWN";
                }
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean isNetworkAvailable(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("connectivity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)object;
            if (connectivityManager == null) {
                return false;
            }
            NetworkInfo[] networkInfo = connectivityManager.getAllNetworkInfo();
            if (networkInfo != null && networkInfo.length > 0) {
                int n = 0;
                int n2 = networkInfo.length;
                while (n < n2) {
                    void i;
                    NetworkInfo networkInfo2 = networkInfo[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)networkInfo2, (String)"networkInfo[i]");
                    if (networkInfo2.getState() == NetworkInfo.State.CONNECTED) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public final boolean isConnected(@NotNull Context context) {
            NetworkInfo info;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("connectivity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
            }
            ConnectivityManager connectivity = (ConnectivityManager)object;
            return connectivity != null && (info = connectivity.getActiveNetworkInfo()) != null && info.isConnected() && info.getState() == NetworkInfo.State.CONNECTED;
        }

        public final boolean isWifi(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getSystemService("connectivity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)object;
            if (connectivityManager == null) {
                return false;
            }
            ConnectivityManager connectivity = connectivityManager;
            NetworkInfo networkInfo = connectivity.getActiveNetworkInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)networkInfo, (String)"connectivity.activeNetworkInfo");
            return networkInfo.getType() == 1;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

