/*
 * Decompiled with CFR 0.152.
 */
package com.easyvolley.interceptors.impl;

import android.util.Log;
import com.android.volley.NetworkResponse;
import com.easyvolley.interceptors.ResponseInterceptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;

public class GzipInterceptor
implements ResponseInterceptor {
    @Override
    public NetworkResponse intercept(NetworkResponse response) {
        String encoding = (String)response.headers.get("Content-Encoding");
        if (response.data != null && encoding != null && encoding.equals("gzip")) {
            Log.d((String)"GzipInterceptor", (String)"Content-Encoding : gzip");
            try {
                int len;
                GZIPInputStream gStream = new GZIPInputStream(new ByteArrayInputStream(response.data));
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                while ((len = gStream.read(buffer)) != -1) {
                    os.write(buffer, 0, len);
                }
                byte[] output = os.toByteArray();
                response = new NetworkResponse(response.statusCode, output, response.notModified, response.networkTimeMs, response.allHeaders);
            }
            catch (IOException e) {
                Log.e((String)"GzipInterceptor", (String)e.getMessage(), (Throwable)e);
            }
        }
        return response;
    }
}

