/*
 * Decompiled with CFR 0.152.
 */
package com.easyvolley.dispatcher;

import android.util.Log;
import com.easyvolley.Callback;
import com.easyvolley.EasyVolleyResponse;
import com.easyvolley.dispatcher.TypeAdapter;
import com.easyvolley.dispatcher.adapter.JsonArrayTypeAdapter;
import com.easyvolley.dispatcher.adapter.JsonObjectTypeAdapter;
import com.easyvolley.dispatcher.adapter.StringTypeAdapter;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class ResponseDispatcher {
    private static final String TAG = ResponseDispatcher.class.getSimpleName();
    private static ResponseDispatcher instance;
    private GsonBuilder gson = new GsonBuilder();
    private HashMap<Type, TypeAdapter> typeAdapterHashMap = new HashMap();

    private ResponseDispatcher() {
        this.resgisterTypeAdapter((Type)((Object)String.class), new StringTypeAdapter());
        this.resgisterTypeAdapter((Type)((Object)JSONObject.class), new JsonObjectTypeAdapter());
        this.resgisterTypeAdapter((Type)((Object)JSONArray.class), new JsonArrayTypeAdapter());
    }

    public void resgisterTypeAdapter(Type t, TypeAdapter adapter) {
        this.typeAdapterHashMap.put(t, adapter);
    }

    public static ResponseDispatcher getInstance() {
        if (instance == null) {
            instance = new ResponseDispatcher();
        }
        return instance;
    }

    public void dispatch(Callback callback, String responseBody, EasyVolleyResponse response) {
        if (callback != null) {
            Type type = callback.getGenericType();
            Log.d((String)TAG, (String)("Callback Type is " + type));
            TypeAdapter adapter = this.typeAdapterHashMap.get(type);
            if (adapter != null) {
                adapter.processResponse(callback, responseBody, response);
                return;
            }
            callback.onSuccess(this.gson.create().fromJson(responseBody, type), response);
        }
    }
}

