/*
 * Decompiled with CFR 0.152.
 */
package com.easyvolley.dispatcher;

import android.os.Process;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.ResponseDelivery;
import com.android.volley.VolleyError;
import com.easyvolley.NetworkRequest;
import java.util.concurrent.BlockingQueue;

public class CacheOnlyDispatcher
extends Thread {
    private static final String TAG = CacheOnlyDispatcher.class.getSimpleName();
    private static final boolean DEBUG = false;
    private final BlockingQueue<NetworkRequest> mCacheOnlyQueue;
    private final Cache mCache;
    private final ResponseDelivery mDelivery;
    private volatile boolean mQuit = false;

    public CacheOnlyDispatcher(BlockingQueue<NetworkRequest> cacheOnlyQueue, Cache cache, ResponseDelivery delivery) {
        this.mCacheOnlyQueue = cacheOnlyQueue;
        this.mCache = cache;
        this.mDelivery = delivery;
    }

    public void quit() {
        this.mQuit = true;
        this.interrupt();
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        this.mCache.initialize();
        while (true) {
            try {
                while (true) {
                    this.processRequest();
                }
            }
            catch (InterruptedException e) {
                if (!this.mQuit) continue;
                return;
            }
            break;
        }
    }

    private void processRequest() throws InterruptedException {
        NetworkRequest request = this.mCacheOnlyQueue.take();
        request.addMarker("cache-queue-take");
        if (request.isCanceled()) {
            return;
        }
        Cache.Entry entry = this.mCache.get(request.getCacheKey());
        if (entry == null) {
            request.addMarker("cache-miss");
            this.mDelivery.postError((Request)request, new VolleyError("No Cache Available"));
            return;
        }
        if (entry.isExpired()) {
            request.addMarker("cache-hit-expired");
            request.setCacheEntry(entry);
            this.mDelivery.postError((Request)request, new VolleyError("Cache has expired"));
            return;
        }
        request.addMarker("cache-hit");
        Response<String> response = request.parseNetworkResponse(new NetworkResponse(entry.data, entry.responseHeaders));
        request.addMarker("cache-hit-parsed");
        this.mDelivery.postResponse((Request)request, response);
    }
}

