/*
 * Decompiled with CFR 0.152.
 */
package com.easyvolley;

import android.net.Uri;
import com.android.volley.Cache;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.easyvolley.Callback;
import com.easyvolley.EasyVolleyError;
import com.easyvolley.EasyVolleyResponse;
import com.easyvolley.NetworkClient;
import com.easyvolley.NetworkPolicy;
import com.easyvolley.NetworkRequest;
import com.easyvolley.dispatcher.ResponseDispatcher;
import com.easyvolley.interceptors.RequestInterceptor;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NetworkRequestBuilder {
    private String mUrl;
    private Callback mCallback;
    private Map<String, String> mHeaders;
    private Uri.Builder builder;
    private NetworkPolicy mNetworkPolicy = NetworkPolicy.DEFAULT;
    private Map<String, String> mParams;
    private byte[] mRequestBody;
    private final int mRequestType;
    private int mSocketTimeoutMs = NetworkClient.defaultSocketTimeoutMs;
    private int mMaxNumRetries = 1;
    private float mBackoffMultiplier = 1.0f;
    private Request.Priority mPriority = Request.Priority.NORMAL;
    private Cache.Entry cachedEntry = null;
    private NetworkRequest request;

    NetworkRequestBuilder(String url, int requestType) {
        this.mUrl = url;
        this.mRequestType = requestType;
    }

    private String getUrl() {
        if (this.builder == null) {
            return this.mUrl;
        }
        return this.builder.build().toString();
    }

    public NetworkRequestBuilder setRequestBody(String requestBody) {
        if (requestBody != null) {
            this.mRequestBody = requestBody.getBytes(Charset.forName("UTF-8"));
        }
        return this;
    }

    public NetworkRequestBuilder setRequestBody(byte[] requestBody) {
        if (requestBody != null) {
            this.mRequestBody = requestBody;
        }
        return this;
    }

    public NetworkRequestBuilder addParams(Map<String, String> params) {
        if (this.mParams == null) {
            this.mParams = new HashMap<String, String>();
        }
        this.mParams.putAll(params);
        return this;
    }

    public NetworkRequestBuilder addParams(String param, String value) {
        if (this.mParams == null) {
            this.mParams = new HashMap<String, String>();
        }
        this.mParams.put(param, value);
        return this;
    }

    public NetworkRequestBuilder setCallback(Callback callBack) {
        if (callBack != null) {
            this.mCallback = callBack;
        }
        return this;
    }

    public NetworkRequestBuilder addHeader(Map<String, String> headers) {
        if (this.mHeaders == null) {
            this.mHeaders = new HashMap<String, String>();
        }
        this.mHeaders.putAll(headers);
        return this;
    }

    public NetworkRequestBuilder addHeader(String key, String value) {
        if (this.mHeaders == null) {
            this.mHeaders = new HashMap<String, String>();
        }
        this.mHeaders.put(key, value);
        return this;
    }

    public NetworkRequestBuilder addQueryParam(String param, String value) {
        if (this.builder == null) {
            this.builder = Uri.parse((String)this.mUrl).buildUpon();
        }
        this.builder.appendQueryParameter(param, value);
        return this;
    }

    public NetworkRequestBuilder setNetworkPolicy(NetworkPolicy networkPolicy) {
        if (networkPolicy != null) {
            this.mNetworkPolicy = networkPolicy;
        }
        return this;
    }

    public NetworkRequestBuilder setSocketTimeoutMS(int socketTimeoutMS) {
        if (socketTimeoutMS > 0) {
            this.mSocketTimeoutMs = socketTimeoutMS;
        }
        return this;
    }

    public NetworkRequestBuilder setMaxNumRetries(int maxNumRetries) {
        if (maxNumRetries > 0) {
            this.mMaxNumRetries = maxNumRetries;
        }
        return this;
    }

    public NetworkRequestBuilder setBackoffMultiplier(float backoffMultiplier) {
        if (backoffMultiplier > 0.0f) {
            this.mBackoffMultiplier = backoffMultiplier;
        }
        return this;
    }

    public NetworkRequestBuilder setPriority(Priority priority) {
        if (priority != null) {
            switch (priority) {
                case LOW: {
                    this.mPriority = Request.Priority.LOW;
                    break;
                }
                case NORMAL: {
                    this.mPriority = Request.Priority.NORMAL;
                    break;
                }
                case HIGH: {
                    this.mPriority = Request.Priority.HIGH;
                    break;
                }
                case IMMEDIATE: {
                    this.mPriority = Request.Priority.IMMEDIATE;
                }
            }
        }
        return this;
    }

    private void onResponse(String response) {
        ResponseDispatcher.getInstance().dispatch(this.mCallback, response, EasyVolleyResponse.fromNetworkResponse(this.request.getNetworkResponse()));
    }

    private void onError(VolleyError error) {
        if (this.mCallback != null) {
            this.mCallback.onError(EasyVolleyError.from(error));
        }
        if (this.cachedEntry != null) {
            NetworkClient.getRequestQueue().getCache().put(this.request.getCacheKey(), this.cachedEntry);
        }
    }

    private void add(NetworkRequest request) {
        Cache.Entry entry;
        if (this.mNetworkPolicy == NetworkPolicy.OFFLINE) {
            NetworkClient.addCacheOnlyRequest(request);
            return;
        }
        request.setShouldCache(this.mNetworkPolicy != NetworkPolicy.NO_CACHE);
        if (this.mNetworkPolicy == NetworkPolicy.IGNORE_READ_BUT_WRITE_CACHE && (entry = NetworkClient.getRequestQueue().getCache().get(request.getCacheKey())) != null) {
            this.cachedEntry = entry;
            NetworkClient.getRequestQueue().getCache().remove(request.getCacheKey());
        }
        NetworkClient.addNetworkRequest(request);
    }

    public NetworkRequest execute() {
        if (this.getUrl() == null) {
            throw new IllegalArgumentException("Empty URL for network request");
        }
        this.request = new NetworkRequest(this.mRequestType, this.getUrl(), this.mHeaders, this.mParams, this.mRequestBody, (Response.Listener<String>)((Response.Listener)this::onResponse), this::onError, this.mPriority);
        List<RequestInterceptor> requestInterceptors = NetworkClient.getRequestInterceptor();
        for (RequestInterceptor i : requestInterceptors) {
            this.request = i.intercept(this.request);
        }
        this.request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(this.mSocketTimeoutMs, this.mMaxNumRetries, this.mBackoffMultiplier));
        this.add(this.request);
        return this.request;
    }

    public static enum Priority {
        LOW,
        NORMAL,
        HIGH,
        IMMEDIATE;

    }
}

