/*
 * Decompiled with CFR 0.152.
 */
package com.easyvolley;

import android.text.TextUtils;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.StringRequest;
import com.easyvolley.NetworkClient;
import com.easyvolley.interceptors.ResponseInterceptor;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NetworkRequest
extends StringRequest {
    private Map<String, String> mParams = new HashMap<String, String>();
    private byte[] mRequestBody;
    private Response.Listener<String> mResponseListener;
    private HashMap<String, String> mHeaders = new HashMap<String, String>(){
        {
            this.put("Accept-Encoding", "gzip");
        }
    };
    private NetworkResponse networkResponse;
    private Request.Priority mPriority = Request.Priority.NORMAL;

    public NetworkRequest(int method, String url, Map<String, String> headers, Map<String, String> params, byte[] requestBody, Response.Listener<String> listener, Response.ErrorListener errorListener, Request.Priority priority) {
        super(method, url, listener, errorListener);
        this.mResponseListener = listener;
        if (headers != null) {
            this.mHeaders.putAll(headers);
        }
        if (params != null) {
            this.mParams.putAll(params);
        }
        this.mRequestBody = requestBody;
        this.mPriority = priority;
    }

    public NetworkRequest(String url, Map<String, String> headers, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        this(0, url, headers, null, null, listener, errorListener, Request.Priority.NORMAL);
    }

    public Map<String, String> getHeaders() {
        Cache.Entry entry = NetworkClient.getRequestQueue().getCache().get(this.getCacheKey());
        if (entry != null && !TextUtils.isEmpty((CharSequence)entry.etag)) {
            this.mHeaders.put("If-None-Match", entry.etag);
        }
        return this.mHeaders;
    }

    public byte[] getBody() {
        return this.mRequestBody;
    }

    public Map<String, String> getParams() {
        return this.mParams;
    }

    public Response.Listener<String> getResponseListener() {
        return this.mResponseListener;
    }

    public Response<String> parseNetworkResponse(NetworkResponse response) {
        String parsed;
        this.networkResponse = response;
        List<ResponseInterceptor> responseInterceptors = NetworkClient.getResponseInterceptor();
        for (ResponseInterceptor i : responseInterceptors) {
            response = i.intercept(response);
        }
        try {
            parsed = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers, (String)"UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            parsed = new String(response.data);
        }
        return Response.success((Object)parsed, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
    }

    public NetworkResponse getNetworkResponse() {
        return this.networkResponse;
    }

    public Request.Priority getPriority() {
        return this.mPriority;
    }

    public void cancelRequest() {
        this.cancel();
    }
}

