/*
 * Decompiled with CFR 0.152.
 */
package com.easyvolley;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.android.volley.Cache;
import com.android.volley.ExecutorDelivery;
import com.android.volley.Network;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.ResponseDelivery;
import com.android.volley.toolbox.BaseHttpStack;
import com.android.volley.toolbox.BasicNetwork;
import com.android.volley.toolbox.DiskBasedCache;
import com.easyvolley.NetworkRequest;
import com.easyvolley.NetworkRequestBuilder;
import com.easyvolley.dispatcher.CacheOnlyDispatcher;
import com.easyvolley.interceptors.RequestInterceptor;
import com.easyvolley.interceptors.ResponseInterceptor;
import com.easyvolley.interceptors.impl.GzipInterceptor;
import com.easyvolley.okhttp3.VolleyOkHttp3StackInterceptors;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;

public class NetworkClient {
    private static int defaultDiskCacheSize = 0x1400000;
    static int defaultSocketTimeoutMs = 2500;
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context mContext;
    @SuppressLint(value={"StaticFieldLeak"})
    private static NetworkClient instance;
    private RequestQueue mRequestQueue;
    private PriorityBlockingQueue<NetworkRequest> mCacheOnlyQueue;
    private CacheOnlyDispatcher mCacheOnlyDispatcher;
    private ArrayList<ResponseInterceptor> responseInterceptors = new ArrayList<ResponseInterceptor>(){
        {
            this.add(new GzipInterceptor());
        }
    };
    private ArrayList<RequestInterceptor> requestInterceptors = new ArrayList<RequestInterceptor>(){};

    public static void addResponseInterceptor(ResponseInterceptor responseInterceptor) {
        NetworkClient.instance.responseInterceptors.add(responseInterceptor);
    }

    public static void addRequestInterceptor(RequestInterceptor requestInterceptor) {
        NetworkClient.instance.requestInterceptors.add(requestInterceptor);
    }

    public static List<ResponseInterceptor> getResponseInterceptor() {
        return NetworkClient.instance.responseInterceptors;
    }

    public static List<RequestInterceptor> getRequestInterceptor() {
        return NetworkClient.instance.requestInterceptors;
    }

    public static void init(Application app) {
        if (instance == null) {
            instance = new NetworkClient((Context)app);
        }
    }

    public static void init(Application app, int socketTimeoutMs) {
        NetworkClient.init(app);
        defaultSocketTimeoutMs = socketTimeoutMs;
    }

    private NetworkClient(Context context) {
        mContext = context;
        this.initRequestQueue();
    }

    private void initRequestQueue() {
        if (this.mRequestQueue == null) {
            DiskBasedCache cache = new DiskBasedCache(mContext.getCacheDir(), defaultDiskCacheSize);
            BasicNetwork network = new BasicNetwork((BaseHttpStack)new VolleyOkHttp3StackInterceptors());
            this.mRequestQueue = new RequestQueue((Cache)cache, (Network)network);
            this.mRequestQueue.start();
        }
    }

    private void initCacheOnlyRequestQueue() {
        if (this.mCacheOnlyDispatcher != null) {
            this.mCacheOnlyDispatcher.quit();
        }
        this.mCacheOnlyQueue = new PriorityBlockingQueue();
        this.mCacheOnlyDispatcher = new CacheOnlyDispatcher(this.mCacheOnlyQueue, this.mRequestQueue.getCache(), (ResponseDelivery)new ExecutorDelivery(new Handler(Looper.getMainLooper())));
        this.mCacheOnlyDispatcher.start();
    }

    public static void setDiskCacheSizeBytes(int diskCacheSizeBytesMs) {
        defaultDiskCacheSize = diskCacheSizeBytesMs;
    }

    public static RequestQueue getRequestQueue() {
        return NetworkClient.instance.mRequestQueue;
    }

    public static void addNetworkRequest(Request<?> request) {
        NetworkClient.instance.mRequestQueue.add(request);
    }

    public static void addCacheOnlyRequest(NetworkRequest networkRequest) {
        if (NetworkClient.instance.mCacheOnlyQueue == null) {
            instance.initCacheOnlyRequestQueue();
        }
        networkRequest.setSequence(NetworkClient.instance.mRequestQueue.getSequenceNumber());
        NetworkClient.instance.mCacheOnlyQueue.add(networkRequest);
    }

    public static void dropAllCache() {
        NetworkClient.instance.mRequestQueue.getCache().clear();
    }

    public static void dropCache(String key) {
        NetworkClient.instance.mRequestQueue.getCache().remove(key);
    }

    public static void setDefaultSocketTimeoutMs(int socketTimeoutMs) {
        defaultSocketTimeoutMs = socketTimeoutMs;
    }

    public static NetworkRequestBuilder get(String url) {
        return new NetworkRequestBuilder(url, 0);
    }

    public static NetworkRequestBuilder post(String url) {
        return new NetworkRequestBuilder(url, 1);
    }

    public static NetworkRequestBuilder put(String url) {
        return new NetworkRequestBuilder(url, 2);
    }

    public static NetworkRequestBuilder delete(String url) {
        return new NetworkRequestBuilder(url, 3);
    }

    public static NetworkRequestBuilder head(String url) {
        return new NetworkRequestBuilder(url, 4);
    }

    public static NetworkRequestBuilder options(String url) {
        return new NetworkRequestBuilder(url, 5);
    }

    public static NetworkRequestBuilder trace(String url) {
        return new NetworkRequestBuilder(url, 6);
    }

    public static NetworkRequestBuilder patch(String url) {
        return new NetworkRequestBuilder(url, 7);
    }
}

