/*
 * Decompiled with CFR 0.152.
 */
package com.easyvolley.builder;

import android.net.Uri;
import com.android.volley.VolleyError;
import com.easyvolley.Callback;
import com.easyvolley.EasyVolleyError;
import com.easyvolley.dispatcher.ResponseDispatcher;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseRequest<T extends BaseRequest> {
    private String mUrl;
    private Callback mCallback;
    private Map<String, String> mHeaders;
    private Uri.Builder builder;

    BaseRequest(String url) {
        this.mUrl = url;
    }

    String getUrl() {
        if (this.builder == null) {
            return this.mUrl;
        }
        return this.builder.build().toString();
    }

    Map<String, String> getHeaders() {
        return this.mHeaders;
    }

    public T setCallback(Callback callBack) {
        if (callBack != null) {
            this.mCallback = callBack;
        }
        return (T)this;
    }

    public T addHeader(Map<String, String> headers) {
        if (this.mHeaders == null) {
            this.mHeaders = new HashMap<String, String>();
        }
        this.mHeaders.putAll(headers);
        return (T)this;
    }

    public T addHeader(String key, String value) {
        if (this.mHeaders == null) {
            this.mHeaders = new HashMap<String, String>();
        }
        this.mHeaders.put(key, value);
        return (T)this;
    }

    public T addQueryParam(String param, String value) {
        if (this.builder == null) {
            this.builder = Uri.parse((String)this.mUrl).buildUpon();
        }
        this.builder.appendQueryParameter(param, value);
        return (T)this;
    }

    void onResponse(String response) {
        ResponseDispatcher.getInstance().dispatch(this.mCallback, response);
    }

    void onError(VolleyError error) {
        if (this.mCallback != null) {
            this.mCallback.onError(EasyVolleyError.from(error));
        }
    }

    public abstract void execute();
}

