/*
 * Decompiled with CFR 0.152.
 */
package com.easyvolley;

import android.text.TextUtils;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.Response;
import com.android.volley.toolbox.StringRequest;
import com.easyvolley.NetworkClient;
import com.easyvolley.interceptors.Interceptor;
import com.easyvolley.interceptors.impl.GzipInterceptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class NetworkRequest
extends StringRequest {
    private Map<String, String> mParams = new HashMap<String, String>();
    private byte[] mRequestBody;
    private HashMap<String, String> mHeaders = new HashMap<String, String>(){
        {
            this.put("Accept-Encoding", "gzip");
        }
    };
    private ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>(){
        {
            this.add(new GzipInterceptor());
        }
    };

    public NetworkRequest(int method, String url, Map<String, String> headers, Map<String, String> params, byte[] requestBody, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        super(method, url, listener, errorListener);
        if (headers != null) {
            this.mHeaders.putAll(headers);
        }
        if (params != null) {
            this.mParams.putAll(params);
        }
        this.mRequestBody = requestBody;
    }

    public NetworkRequest(String url, Map<String, String> headers, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        this(0, url, headers, null, null, listener, errorListener);
    }

    public void addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public Map<String, String> getHeaders() {
        Cache.Entry entry = NetworkClient.getRequestQueue().getCache().get(this.getCacheKey());
        if (entry != null && !TextUtils.isEmpty((CharSequence)entry.etag)) {
            this.mHeaders.put("If-None-Match", entry.etag);
        }
        return this.mHeaders;
    }

    public byte[] getBody() {
        return this.mRequestBody;
    }

    protected Map<String, String> getParams() {
        return this.mParams;
    }

    protected Response<String> parseNetworkResponse(NetworkResponse response) {
        for (Interceptor i : this.interceptors) {
            response = i.intercept(response);
        }
        return super.parseNetworkResponse(response);
    }
}

