/*
 * Decompiled with CFR 0.152.
 */
package com.easyvolley;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import com.android.volley.Cache;
import com.android.volley.Network;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.BaseHttpStack;
import com.android.volley.toolbox.BasicNetwork;
import com.android.volley.toolbox.DiskBasedCache;
import com.android.volley.toolbox.HurlStack;
import com.easyvolley.builder.GetRequest;
import com.easyvolley.builder.PostRequest;

public class NetworkClient {
    private static int defaultDiskCacheSize = 0x1400000;
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context mContext;
    @SuppressLint(value={"StaticFieldLeak"})
    private static NetworkClient instance;
    private RequestQueue mRequestQueue;

    public static void init(Application app) {
        if (instance == null) {
            instance = new NetworkClient((Context)app);
        }
    }

    private NetworkClient(Context context) {
        mContext = context;
        this.initRequestQueue();
    }

    private void initRequestQueue() {
        if (this.mRequestQueue == null) {
            DiskBasedCache cache = new DiskBasedCache(mContext.getCacheDir(), defaultDiskCacheSize);
            BasicNetwork network = new BasicNetwork((BaseHttpStack)new HurlStack());
            this.mRequestQueue = new RequestQueue((Cache)cache, (Network)network);
            this.mRequestQueue.start();
        }
    }

    public static void setDiskCacheSizeBytes(int diskCacheSizeBytesMs) {
        defaultDiskCacheSize = diskCacheSizeBytesMs;
    }

    public static RequestQueue getRequestQueue() {
        return NetworkClient.instance.mRequestQueue;
    }

    public static GetRequest get(String url) {
        return new GetRequest(url);
    }

    public static PostRequest post(String url) {
        return new PostRequest(url);
    }
}

