/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.korim.qr;

import com.soywiz.korim.qr.QR8bitByte;
import com.soywiz.korim.qr.QRBitBuffer;
import com.soywiz.korim.qr.QRErrorCorrectLevel;
import com.soywiz.korim.qr.QRPolynomial;
import com.soywiz.korim.qr.QRRSBlock;
import com.soywiz.korim.qr.QRUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0002\u0018\u0000 72\u00020\u0001:\u00017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020(J\u0006\u0010)\u001a\u00020\u0003J\u0016\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003J\u0006\u0010-\u001a\u00020%J\u0016\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u0003J\u0016\u00101\u001a\u00020%2\u0006\u0010&\u001a\u00020\b2\u0006\u00100\u001a\u00020\u0003J\u0006\u00102\u001a\u00020%J\u0016\u00103\u001a\u00020%2\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003J\u0006\u00104\u001a\u00020%J\u0016\u00105\u001a\u00020%2\u0006\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u0003J\u000e\u00106\u001a\u00020%2\u0006\u0010/\u001a\u00020\u001dR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR*\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR*\u0010\u001b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001c0\u001cX\u0086.\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001a\u00a8\u00068"}, d2={"Lcom/soywiz/korim/qr/QRCodeModel;", "", "typeNumber", "", "errorCorrectLevel", "Lcom/soywiz/korim/qr/QRErrorCorrectLevel;", "(ILcom/soywiz/korim/qr/QRErrorCorrectLevel;)V", "dataCache", "", "getDataCache", "()[I", "setDataCache", "([I)V", "dataList", "Ljava/util/ArrayList;", "Lcom/soywiz/korim/qr/QR8bitByte;", "Lkotlin/collections/ArrayList;", "getDataList", "()Ljava/util/ArrayList;", "setDataList", "(Ljava/util/ArrayList;)V", "getErrorCorrectLevel", "()Lcom/soywiz/korim/qr/QRErrorCorrectLevel;", "<set-?>", "moduleCount", "getModuleCount", "()I", "modules", "", "", "getModules", "()[[Ljava/lang/Boolean;", "setModules", "([[Ljava/lang/Boolean;)V", "[[Ljava/lang/Boolean;", "getTypeNumber", "addData", "", "data", "", "", "getBestMaskPattern", "isDark", "row", "col", "make", "makeImpl", "test", "maskPattern", "mapData", "setupPositionAdjustPattern", "setupPositionProbePattern", "setupTimingPattern", "setupTypeInfo", "setupTypeNumber", "Companion", "korim-qr_debug"})
final class QRCodeModel {
    @NotNull
    public Boolean[][] modules;
    private int moduleCount;
    @Nullable
    private int[] dataCache;
    @NotNull
    private ArrayList<QR8bitByte> dataList;
    private final int typeNumber;
    @NotNull
    private final QRErrorCorrectLevel errorCorrectLevel;
    public static final int PAD0 = 236;
    public static final int PAD1 = 17;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Boolean[][] getModules() {
        if (this.modules == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
        }
        return this.modules;
    }

    public final void setModules(@NotNull Boolean[][] booleanArray) {
        Intrinsics.checkParameterIsNotNull((Object)booleanArray, (String)"<set-?>");
        this.modules = booleanArray;
    }

    public final int getModuleCount() {
        return this.moduleCount;
    }

    @Nullable
    public final int[] getDataCache() {
        return this.dataCache;
    }

    public final void setDataCache(@Nullable int[] nArray) {
        this.dataCache = nArray;
    }

    @NotNull
    public final ArrayList<QR8bitByte> getDataList() {
        return this.dataList;
    }

    public final void setDataList(@NotNull ArrayList<QR8bitByte> arrayList) {
        Intrinsics.checkParameterIsNotNull(arrayList, (String)"<set-?>");
        this.dataList = arrayList;
    }

    public final void addData(@NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.dataList.add(QR8bitByte.Companion.invoke(data));
        this.dataCache = null;
    }

    public final void addData(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.dataList.add(new QR8bitByte(data));
        this.dataCache = null;
    }

    public final boolean isDark(int row, int col) {
        if (row < 0 || this.moduleCount <= row || col < 0 || this.moduleCount <= col) {
            String string = "" + row + ',' + col;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (this.modules == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
        }
        Boolean bl = this.modules[row][col];
        return bl != null ? bl : false;
    }

    public final void make() {
        this.makeImpl(false, this.getBestMaskPattern());
    }

    /*
     * WARNING - void declaration
     */
    public final void makeImpl(boolean test, int maskPattern) {
        Boolean[][] booleanArrayArray;
        int i$iv;
        int size$iv;
        this.moduleCount = this.typeNumber * 4 + 17;
        if (this.moduleCount <= 0) {
            String string = "Invalid moduleCount";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int n = this.moduleCount;
        Boolean[][] booleanArray = this;
        Boolean[][] result$iv = new Boolean[size$iv][];
        int n2 = 0;
        int n3 = result$iv.length;
        while (n2 < n3) {
            void var7_11 = i$iv;
            int n4 = i$iv++;
            booleanArrayArray = result$iv;
            boolean bl = false;
            Boolean[] booleanArray2 = new Boolean[]{};
            booleanArrayArray[n4] = booleanArray2;
        }
        booleanArrayArray = result$iv;
        booleanArray.modules = booleanArrayArray;
        size$iv = 0;
        int n5 = this.moduleCount;
        while (size$iv < n5) {
            Boolean[] booleanArray3;
            int size$iv2;
            void row;
            if (this.modules == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
            }
            i$iv = this.moduleCount;
            void var13_14 = row;
            booleanArray = this.modules;
            Boolean[] result$iv2 = new Boolean[size$iv2];
            int it = 0;
            int n6 = result$iv2.length;
            while (it < n6) {
                void i$iv2;
                void $i$f$Array = i$iv2;
                void var15_18 = i$iv2++;
                booleanArray3 = result$iv2;
                boolean bl = false;
                Object var16_21 = null;
                booleanArray3[var15_18] = var16_21;
            }
            booleanArray3 = result$iv2;
            booleanArray[var13_14] = booleanArray3;
            size$iv2 = 0;
            n3 = this.moduleCount;
            while (size$iv2 < n3) {
                void col;
                if (this.modules == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
                }
                this.modules[row][col] = null;
                ++col;
            }
            ++row;
        }
        this.setupPositionProbePattern(0, 0);
        this.setupPositionProbePattern(this.moduleCount - 7, 0);
        this.setupPositionProbePattern(0, this.moduleCount - 7);
        this.setupPositionAdjustPattern();
        this.setupTimingPattern();
        this.setupTypeInfo(test, maskPattern);
        if (this.typeNumber >= 7) {
            this.setupTypeNumber(test);
        }
        if (this.dataCache == null) {
            this.dataCache = Companion.createData(this.typeNumber, this.errorCorrectLevel, (List<QR8bitByte>)this.dataList);
        }
        if (this.dataCache == null) {
            Intrinsics.throwNpe();
        }
        this.mapData(this.dataCache, maskPattern);
    }

    /*
     * WARNING - void declaration
     */
    public final void setupPositionProbePattern(int row, int col) {
        int n = -1;
        int n2 = 7;
        while (n <= n2) {
            void r;
            if (row + r > -1 && this.moduleCount > row + r) {
                int n3 = -1;
                int n4 = 7;
                while (n3 <= n4) {
                    void c;
                    if (col + c > -1 && this.moduleCount > col + c) {
                        void var7_7;
                        if (this.modules == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
                        }
                        this.modules[row + r][col + c] = false <= (var7_7 = r) && 6 >= var7_7 && (c == false || c == 6) || false <= (var7_7 = c) && 6 >= var7_7 && (r == false || r == 6) || 2 <= (var7_7 = r) && 4 >= var7_7 && 2 <= c && c <= 4;
                    }
                    ++c;
                }
            }
            ++r;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getBestMaskPattern() {
        int minLostPoint = 0;
        int pattern = 0;
        int n = 0;
        int n2 = 8;
        while (n < n2) {
            void i;
            this.makeImpl(true, (int)i);
            int lostPoint = QRUtil.INSTANCE.getLostPoint(this);
            if (i == false || minLostPoint > lostPoint) {
                minLostPoint = lostPoint;
                pattern = i;
            }
            ++i;
        }
        return pattern;
    }

    /*
     * WARNING - void declaration
     */
    public final void setupTimingPattern() {
        int r;
        int n = 8;
        int n2 = this.moduleCount - 8;
        while (n < n2) {
            if (this.modules == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
            }
            if (this.modules[r][6] == null) {
                if (this.modules == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
                }
                this.modules[r][6] = r % 2 == 0;
            }
            ++r;
        }
        r = 8;
        n2 = this.moduleCount - 8;
        while (r < n2) {
            void c;
            if (this.modules == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
            }
            if (this.modules[6][c] == null) {
                if (this.modules == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
                }
                this.modules[6][c] = c % 2 == false;
            }
            ++c;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setupPositionAdjustPattern() {
        int[] pos = QRUtil.INSTANCE.getPatternPosition(this.typeNumber);
        int n = 0;
        int n2 = pos.length;
        while (n < n2) {
            void i;
            int n3 = 0;
            int n4 = pos.length;
            while (n3 < n4) {
                void j;
                int row = pos[i];
                int col = pos[j];
                if (this.modules == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
                }
                if (this.modules[row][col] == null) {
                    int n5 = -2;
                    int n6 = 2;
                    while (n5 <= n6) {
                        void r;
                        int n7 = -2;
                        int n8 = 2;
                        while (n7 <= n8) {
                            void c;
                            if (this.modules == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
                            }
                            this.modules[row + r][col + c] = r == -2 || r == 2 || c == -2 || c == 2 || r == false && c == false;
                            ++c;
                        }
                        ++r;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public final void setupTypeNumber(boolean test) {
        int i;
        boolean mod;
        int bits = QRUtil.INSTANCE.getBCHTypeNumber(this.typeNumber);
        int n = 0;
        int n2 = 18;
        while (n < n2) {
            boolean bl = mod = !test && (bits >> i & 1) == 1;
            if (this.modules == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
            }
            this.modules[i / 3][i % 3 + this.moduleCount - 8 - 3] = mod;
            ++i;
        }
        n2 = 18;
        for (i = 0; i < n2; ++i) {
            boolean bl = mod = !test && (bits >> i & 1) == 1;
            if (this.modules == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
            }
            this.modules[i % 3 + this.moduleCount - 8 - 3][i / 3] = mod;
        }
    }

    public final void setupTypeInfo(boolean test, int maskPattern) {
        int i;
        boolean mod;
        int data = this.errorCorrectLevel.getId() << 3 | maskPattern;
        int bits = QRUtil.INSTANCE.getBCHTypeInfo(data);
        int n = 0;
        int n2 = 15;
        while (n < n2) {
            boolean bl = mod = !test && (bits >> i & 1) == 1;
            if (i < 6) {
                if (this.modules == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
                }
                this.modules[i][8] = mod;
            } else if (i < 8) {
                if (this.modules == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
                }
                this.modules[i + 1][8] = mod;
            } else {
                if (this.modules == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
                }
                this.modules[this.moduleCount - 15 + i][8] = mod;
            }
            ++i;
        }
        n2 = 15;
        for (i = 0; i < n2; ++i) {
            boolean bl = mod = !test && (bits >> i & 1) == 1;
            if (i < 8) {
                if (this.modules == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
                }
                this.modules[8][this.moduleCount - i - 1] = mod;
                continue;
            }
            if (i < 9) {
                if (this.modules == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
                }
                this.modules[8][15 - i - 1 + 1] = mod;
                continue;
            }
            if (this.modules == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
            }
            this.modules[8][15 - i - 1] = mod;
        }
        if (this.modules == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
        }
        this.modules[this.moduleCount - 8][8] = !test;
    }

    /*
     * WARNING - void declaration
     */
    public final void mapData(@NotNull int[] data, int maskPattern) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        int inc = -1;
        int row = this.moduleCount - 1;
        int bitIndex = 7;
        int byteIndex = 0;
        for (int col = this.moduleCount - 1; col > 0; col -= 2) {
            if (col == 6) {
                --col;
            }
            do {
                int n = 0;
                int n2 = 2;
                while (n < n2) {
                    void c;
                    if (this.modules == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
                    }
                    if (this.modules[row][col - c] == null) {
                        boolean mask;
                        boolean dark = false;
                        if (byteIndex < data.length) {
                            boolean bl = dark = (data[byteIndex] >>> bitIndex & 1) == 1;
                        }
                        if (mask = QRUtil.INSTANCE.getMask(maskPattern, row, col - c)) {
                            boolean bl = dark = !dark;
                        }
                        if (this.modules == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"modules");
                        }
                        this.modules[row][col - c] = dark;
                        if (--bitIndex == -1) {
                            ++byteIndex;
                            bitIndex = 7;
                        }
                    }
                    ++c;
                }
            } while ((row += inc) >= 0 && this.moduleCount > row);
            row -= inc;
            inc = -inc;
        }
    }

    public final int getTypeNumber() {
        return this.typeNumber;
    }

    @NotNull
    public final QRErrorCorrectLevel getErrorCorrectLevel() {
        return this.errorCorrectLevel;
    }

    public QRCodeModel(int typeNumber, @NotNull QRErrorCorrectLevel errorCorrectLevel) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)errorCorrectLevel), (String)"errorCorrectLevel");
        this.typeNumber = typeNumber;
        this.errorCorrectLevel = errorCorrectLevel;
        QRCodeModel qRCodeModel = this;
        ArrayList arrayList = new ArrayList();
        qRCodeModel.dataList = arrayList;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ$\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/soywiz/korim/qr/QRCodeModel$Companion;", "", "()V", "PAD0", "", "PAD1", "createBytes", "", "buffer", "Lcom/soywiz/korim/qr/QRBitBuffer;", "rsBlocks", "", "Lcom/soywiz/korim/qr/QRRSBlock;", "createData", "typeNumber", "errorCorrectLevel", "Lcom/soywiz/korim/qr/QRErrorCorrectLevel;", "dataList", "Lcom/soywiz/korim/qr/QR8bitByte;", "korim-qr_debug"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final int[] createData(int typeNumber, @NotNull QRErrorCorrectLevel errorCorrectLevel, @NotNull List<QR8bitByte> dataList) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)errorCorrectLevel), (String)"errorCorrectLevel");
            Intrinsics.checkParameterIsNotNull(dataList, (String)"dataList");
            List<QRRSBlock> rsBlocks = QRRSBlock.Companion.getRSBlocks(typeNumber, errorCorrectLevel);
            QRBitBuffer buffer = new QRBitBuffer();
            int n = 0;
            int n2 = dataList.size();
            while (n < n2) {
                void i;
                QR8bitByte data = dataList.get((int)i);
                buffer.put(data.getMode(), 4);
                buffer.put(data.getLength(), QRUtil.INSTANCE.getLengthInBits(data.getMode(), typeNumber));
                data.write(buffer);
                ++i;
            }
            int totalDataCount = 0;
            n2 = 0;
            int n3 = rsBlocks.size();
            while (n2 < n3) {
                void i;
                totalDataCount += rsBlocks.get((int)i).getDataCount();
                ++i;
            }
            if (buffer.getLengthInBits() > totalDataCount * 8) {
                String string = "code length overflow. (" + buffer.getLengthInBits() + '>' + totalDataCount * 8 + ')';
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (buffer.getLengthInBits() + 4 <= totalDataCount * 8) {
                buffer.put(0, 4);
            }
            while (buffer.getLengthInBits() % 8 != 0) {
                buffer.putBit(false);
            }
            while (buffer.getLengthInBits() < totalDataCount * 8) {
                buffer.put(236, 8);
                if (buffer.getLengthInBits() >= totalDataCount * 8) break;
                buffer.put(17, 8);
            }
            return Companion.createBytes(buffer, rsBlocks);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final int[] createBytes(@NotNull QRBitBuffer buffer, @NotNull List<QRRSBlock> rsBlocks) {
            int i;
            int ecCount;
            int dcCount;
            int[] nArray;
            boolean bl;
            int[][] nArrayArray;
            void var19_21;
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            Intrinsics.checkParameterIsNotNull(rsBlocks, (String)"rsBlocks");
            int offset = 0;
            int maxDcCount = 0;
            int maxEcCount = 0;
            int size$iv = rsBlocks.size();
            int[][] result$iv = new int[size$iv][];
            int n = 0;
            int n2 = result$iv.length;
            while (n < n2) {
                void i$iv;
                void var11_15 = i$iv;
                var19_21 = i$iv++;
                nArrayArray = result$iv;
                bl = false;
                nArray = new int[]{};
                nArrayArray[var19_21] = nArray;
            }
            int[][] dcdata = result$iv;
            int size$iv2 = rsBlocks.size();
            int[][] result$iv22 = new int[size$iv2][];
            n2 = 0;
            int it = result$iv22.length;
            while (n2 < it) {
                void i$iv;
                bl = i$iv;
                var19_21 = i$iv++;
                nArrayArray = result$iv22;
                boolean bl2 = false;
                nArray = new int[]{};
                nArrayArray[var19_21] = nArray;
            }
            int[][] ecdata = result$iv22;
            size$iv2 = 0;
            int result$iv22 = rsBlocks.size();
            while (size$iv2 < result$iv22) {
                void r;
                dcCount = rsBlocks.get((int)r).getDataCount();
                ecCount = rsBlocks.get((int)r).getTotalCount() - dcCount;
                maxDcCount = Math.max(maxDcCount, dcCount);
                maxEcCount = Math.max(maxEcCount, ecCount);
                dcdata[r] = new int[dcCount];
                int it2 = 0;
                int bl2 = dcdata[r].length;
                while (it2 < bl2) {
                    void i2;
                    dcdata[r][i2] = 0xFF & buffer.getBuffer().get((int)(i2 + offset));
                    ++i2;
                }
                offset += dcCount;
                QRPolynomial rsPoly = QRUtil.INSTANCE.getErrorCorrectPolynomial(ecCount);
                QRPolynomial rawPoly = new QRPolynomial(dcdata[r], rsPoly.getLength() - 1);
                QRPolynomial modPoly = rawPoly.mod(rsPoly);
                ecdata[r] = new int[rsPoly.getLength() - 1];
                int n3 = 0;
                int n4 = ecdata[r].length;
                while (n3 < n4) {
                    void i3;
                    void modIndex = i3 + modPoly.getLength() - ecdata[r].length;
                    ecdata[r][i3] = modIndex >= 0 ? modPoly.get((int)modIndex) : 0;
                    ++i3;
                }
                ++r;
            }
            int totalCodeCount = 0;
            result$iv22 = 0;
            dcCount = rsBlocks.size();
            while (result$iv22 < dcCount) {
                void i4;
                totalCodeCount += rsBlocks.get((int)i4).getTotalCount();
                ++i4;
            }
            int[] data = new int[totalCodeCount];
            int index = 0;
            ecCount = 0;
            int n5 = maxDcCount;
            while (ecCount < n5) {
                int rawPoly = 0;
                int n6 = rsBlocks.size();
                while (rawPoly < n6) {
                    void r;
                    if (i < dcdata[r].length) {
                        data[index++] = dcdata[r][i];
                    }
                    ++r;
                }
                ++i;
            }
            n5 = maxEcCount;
            for (i = 0; i < n5; ++i) {
                int n7 = rsBlocks.size();
                for (int r = 0; r < n7; ++r) {
                    if (i >= ecdata[r].length) continue;
                    data[index++] = ecdata[r][i];
                }
            }
            return data;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

