/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.korim.qr;

import com.soywiz.korim.qr.QRCodeModel;
import com.soywiz.korim.qr.QRMath;
import com.soywiz.korim.qr.QRPolynomial;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004J\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lcom/soywiz/korim/qr/QRUtil;", "", "()V", "G15", "", "G15_MASK", "G18", "PATTERN_POSITION_TABLE", "", "", "getPATTERN_POSITION_TABLE", "()Ljava/util/List;", "getBCHDigit", "data", "getBCHTypeInfo", "getBCHTypeNumber", "getErrorCorrectPolynomial", "Lcom/soywiz/korim/qr/QRPolynomial;", "errorCorrectLength", "getLengthInBits", "mode", "type", "getLostPoint", "qrCode", "Lcom/soywiz/korim/qr/QRCodeModel;", "getMask", "", "maskPattern", "i", "j", "getPatternPosition", "typeNumber", "korim-qr_debug"})
final class QRUtil {
    @NotNull
    private static final List<int[]> PATTERN_POSITION_TABLE;
    public static final int G15 = 1335;
    public static final int G18 = 7973;
    public static final int G15_MASK = 21522;
    public static final QRUtil INSTANCE;

    @NotNull
    public final List<int[]> getPATTERN_POSITION_TABLE() {
        return PATTERN_POSITION_TABLE;
    }

    public final int getBCHTypeInfo(int data) {
        int d = data << 10;
        while (INSTANCE.getBCHDigit(d) - INSTANCE.getBCHDigit(1335) >= 0) {
            d ^= 1335 << INSTANCE.getBCHDigit(d) - INSTANCE.getBCHDigit(1335);
        }
        return (data << 10 | d) ^ 0x5412;
    }

    public final int getBCHTypeNumber(int data) {
        int d = data << 12;
        while (INSTANCE.getBCHDigit(d) - INSTANCE.getBCHDigit(7973) >= 0) {
            d ^= 7973 << INSTANCE.getBCHDigit(d) - INSTANCE.getBCHDigit(7973);
        }
        return data << 12 | d;
    }

    public final int getBCHDigit(int data) {
        int digit = 0;
        for (int dd = data; dd != 0; dd >>>= 1) {
            ++digit;
        }
        return digit;
    }

    @NotNull
    public final int[] getPatternPosition(int typeNumber) {
        return PATTERN_POSITION_TABLE.get(typeNumber - 1);
    }

    public final boolean getMask(int maskPattern, int i, int j) {
        boolean bl;
        switch (maskPattern) {
            case 0: {
                if ((i + j) % 2 == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                if (i % 2 == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (j % 3 == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                if ((i + j) % 3 == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                if ((i / 2 + j / 3) % 2 == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 5: {
                if (i * j % 2 + i * j % 3 == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 6: {
                if ((i * j % 2 + i * j % 3) % 2 == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 7: {
                if ((i * j % 3 + (i + j) % 2) % 2 == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                String string = "bad maskPattern:" + maskPattern;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final QRPolynomial getErrorCorrectPolynomial(int errorCorrectLength) {
        QRPolynomial a = new QRPolynomial(new int[]{1}, 0);
        int n = 0;
        int n2 = errorCorrectLength;
        while (n < n2) {
            void i;
            a = a.multiply(new QRPolynomial(new int[]{1, QRMath.INSTANCE.gexp((int)i)}, 0));
            ++i;
        }
        return a;
    }

    public final int getLengthInBits(int mode, int type) {
        int n;
        block19: {
            block21: {
                int n2;
                int n3;
                block20: {
                    block18: {
                        n3 = type;
                        n2 = n3;
                        if (1 > n2 || 9 < n2) break block18;
                        switch (mode) {
                            case 1: {
                                n = 10;
                                break block19;
                            }
                            case 2: {
                                n = 9;
                                break block19;
                            }
                            case 4: {
                                n = 8;
                                break block19;
                            }
                            case 8: {
                                n = 8;
                                break block19;
                            }
                            default: {
                                String string = "mode:" + mode;
                                throw (Throwable)new IllegalStateException(string.toString());
                            }
                        }
                    }
                    n2 = n3;
                    if (10 > n2 || 27 < n2) break block20;
                    switch (mode) {
                        case 1: {
                            n = 12;
                            break block19;
                        }
                        case 2: {
                            n = 11;
                            break block19;
                        }
                        case 4: {
                            n = 16;
                            break block19;
                        }
                        case 8: {
                            n = 10;
                            break block19;
                        }
                        default: {
                            String string = "mode:" + mode;
                            throw (Throwable)new IllegalStateException(string.toString());
                        }
                    }
                }
                n2 = n3;
                if (28 > n2 || 41 < n2) break block21;
                switch (mode) {
                    case 1: {
                        n = 14;
                        break block19;
                    }
                    case 2: {
                        n = 13;
                        break block19;
                    }
                    case 4: {
                        n = 16;
                        break block19;
                    }
                    case 8: {
                        n = 12;
                        break block19;
                    }
                    default: {
                        String string = "mode:" + mode;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                }
            }
            String string = "type:" + type;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int getLostPoint(@NotNull QRCodeModel qrCode) {
        int col;
        int row;
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull((Object)qrCode, (String)"qrCode");
        int moduleCount = qrCode.getModuleCount();
        int lostPoint = 0;
        int n3 = 0;
        int n4 = moduleCount;
        while (n3 < n4) {
            n2 = 0;
            n = moduleCount;
            while (n2 < n) {
                int sameCount = 0;
                boolean dark = qrCode.isDark(row, col);
                int n5 = -1;
                int n6 = 1;
                while (n5 <= n6) {
                    void r;
                    if (row + r >= 0 && moduleCount > row + r) {
                        int n7 = -1;
                        int n8 = 1;
                        while (n7 <= n8) {
                            void c;
                            if (col + c >= 0 && moduleCount > col + c && (r != false || c != false) && dark == qrCode.isDark(row + r, col + c)) {
                                ++sameCount;
                            }
                            ++c;
                        }
                    }
                    ++r;
                }
                if (sameCount > 5) {
                    lostPoint += 3 + sameCount - 5;
                }
                ++col;
            }
            ++row;
        }
        n4 = moduleCount - 1;
        for (row = 0; row < n4; ++row) {
            n = moduleCount - 1;
            for (col = 0; col < n; ++col) {
                int count = 0;
                if (qrCode.isDark(row, col)) {
                    ++count;
                }
                if (qrCode.isDark(row + 1, col)) {
                    ++count;
                }
                if (qrCode.isDark(row, col + 1)) {
                    ++count;
                }
                if (qrCode.isDark(row + 1, col + 1)) {
                    ++count;
                }
                if (count != 0 && count != 4) continue;
                lostPoint += 3;
            }
        }
        n4 = moduleCount;
        for (row = 0; row < n4; ++row) {
            n = moduleCount - 6;
            for (col = 0; col < n; ++col) {
                if (!qrCode.isDark(row, col) || qrCode.isDark(row, col + 1) || !qrCode.isDark(row, col + 2) || !qrCode.isDark(row, col + 3) || !qrCode.isDark(row, col + 4) || qrCode.isDark(row, col + 5) || !qrCode.isDark(row, col + 6)) continue;
                lostPoint += 40;
            }
        }
        row = 0;
        n4 = moduleCount;
        while (row < n4) {
            void col2;
            col = 0;
            n = moduleCount - 6;
            while (col < n) {
                void row2;
                if (qrCode.isDark((int)row2, (int)col2) && !qrCode.isDark((int)(row2 + true), (int)col2) && qrCode.isDark((int)(row2 + 2), (int)col2) && qrCode.isDark((int)(row2 + 3), (int)col2) && qrCode.isDark((int)(row2 + 4), (int)col2) && !qrCode.isDark((int)(row2 + 5), (int)col2) && qrCode.isDark((int)(row2 + 6), (int)col2)) {
                    lostPoint += 40;
                }
                ++row2;
            }
            ++col2;
        }
        int darkCount = 0;
        n4 = 0;
        n2 = moduleCount;
        while (n4 < n2) {
            void col3;
            n = 0;
            int n9 = moduleCount;
            while (n < n9) {
                void row3;
                if (qrCode.isDark((int)row3, (int)col3)) {
                    ++darkCount;
                }
                ++row3;
            }
            ++col3;
        }
        n2 = 100 * darkCount / moduleCount / moduleCount - 50;
        int ratio = Math.abs(n2) / 5;
        return lostPoint += ratio * 10;
    }

    private QRUtil() {
    }

    static {
        QRUtil qRUtil;
        INSTANCE = qRUtil = new QRUtil();
        PATTERN_POSITION_TABLE = CollectionsKt.listOf((Object[])new int[][]{new int[0], {6, 18}, {6, 22}, {6, 26}, {6, 30}, {6, 34}, {6, 22, 38}, {6, 24, 42}, {6, 26, 46}, {6, 28, 50}, {6, 30, 54}, {6, 32, 58}, {6, 34, 62}, {6, 26, 46, 66}, {6, 26, 48, 70}, {6, 26, 50, 74}, {6, 30, 54, 78}, {6, 30, 56, 82}, {6, 30, 58, 86}, {6, 34, 62, 90}, {6, 28, 50, 72, 94}, {6, 26, 50, 74, 98}, {6, 30, 54, 78, 102}, {6, 28, 54, 80, 106}, {6, 32, 58, 84, 110}, {6, 30, 58, 86, 114}, {6, 34, 62, 90, 118}, {6, 26, 50, 74, 98, 122}, {6, 30, 54, 78, 102, 126}, {6, 26, 52, 78, 104, 130}, {6, 30, 56, 82, 108, 134}, {6, 34, 60, 86, 112, 138}, {6, 30, 58, 86, 114, 142}, {6, 34, 62, 90, 118, 146}, {6, 30, 54, 78, 102, 126, 150}, {6, 24, 50, 76, 102, 128, 154}, {6, 28, 54, 80, 106, 132, 158}, {6, 32, 58, 84, 110, 136, 162}, {6, 26, 54, 82, 110, 138, 166}, {6, 30, 58, 86, 114, 142, 170}});
    }
}

