/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.korim.format;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Typeface;
import com.soywiz.korim.color.BGRA;
import com.soywiz.korim.color.ColorFormatKt;
import com.soywiz.korim.format.AndroidContext2dRenderer$WhenMappings;
import com.soywiz.korim.vector.Context2d;
import com.soywiz.korim.vector.GraphicsPath;
import com.soywiz.korma.geom.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001aJ \u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020)H\u0016J\"\u0010*\u001a\u0002H+\"\u0004\b\u0000\u0010+2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H+0-H\u0086\b\u00a2\u0006\u0002\u0010.J\u0018\u0010/\u001a\u00020 2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J8\u00104\u001a\u00020 2\u0006\u00100\u001a\u0002012\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002062\u0006\u00102\u001a\u000203H\u0016J\u0018\u00108\u001a\u00020 2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\n\u00109\u001a\u00020:*\u00020;R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0014\u00a8\u0006<"}, d2={"Lcom/soywiz/korim/format/AndroidContext2dRenderer;", "Lcom/soywiz/korim/vector/Context2d$Renderer;", "bmp", "Landroid/graphics/Bitmap;", "(Landroid/graphics/Bitmap;)V", "androidMatrix", "Landroid/graphics/Matrix;", "getAndroidMatrix", "()Landroid/graphics/Matrix;", "setAndroidMatrix", "(Landroid/graphics/Matrix;)V", "getBmp", "()Landroid/graphics/Bitmap;", "canvas", "Landroid/graphics/Canvas;", "getCanvas", "()Landroid/graphics/Canvas;", "height", "", "getHeight", "()I", "matrixValues", "", "getMatrixValues", "()[F", "paint", "Landroid/graphics/Paint;", "getPaint", "()Landroid/graphics/Paint;", "width", "getWidth", "convertPaint", "", "c", "Lcom/soywiz/korim/vector/Context2d$Paint;", "out", "getBounds", "font", "Lcom/soywiz/korim/vector/Context2d$Font;", "text", "", "Lcom/soywiz/korim/vector/Context2d$TextMetrics;", "keep", "T", "callback", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "render", "state", "Lcom/soywiz/korim/vector/Context2d$State;", "fill", "", "renderText", "x", "", "y", "setState", "toAndroid", "Landroid/graphics/Path;", "Lcom/soywiz/korim/vector/GraphicsPath;", "korim_release"})
public final class AndroidContext2dRenderer
extends Context2d.Renderer {
    @NotNull
    private final Paint paint;
    @NotNull
    private final Canvas canvas;
    @NotNull
    private final float[] matrixValues;
    @NotNull
    private Matrix androidMatrix;
    @NotNull
    private final Bitmap bmp;

    @Override
    public int getWidth() {
        return this.bmp.getWidth();
    }

    @Override
    public int getHeight() {
        return this.bmp.getHeight();
    }

    @NotNull
    public final Paint getPaint() {
        return this.paint;
    }

    @NotNull
    public final Canvas getCanvas() {
        return this.canvas;
    }

    @NotNull
    public final float[] getMatrixValues() {
        return this.matrixValues;
    }

    @NotNull
    public final Matrix getAndroidMatrix() {
        return this.androidMatrix;
    }

    public final void setAndroidMatrix(@NotNull Matrix matrix) {
        Intrinsics.checkParameterIsNotNull((Object)matrix, (String)"<set-?>");
        this.androidMatrix = matrix;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path toAndroid(@NotNull GraphicsPath $receiver) {
        Path.FillType fillType;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Path out = new Path();
        switch (AndroidContext2dRenderer$WhenMappings.$EnumSwitchMapping$0[$receiver.getWinding().ordinal()]) {
            case 1: {
                fillType = Path.FillType.EVEN_ODD;
                break;
            }
            case 2: {
                fillType = Path.FillType.INVERSE_EVEN_ODD;
                break;
            }
            default: {
                fillType = Path.FillType.EVEN_ODD;
            }
        }
        out.setFillType(fillType);
        GraphicsPath this_$iv = $receiver;
        boolean $i$f$visitCmds = false;
        int n$iv = 0;
        Iterator iterator = this_$iv.getCommands().iterator();
        while (iterator.hasNext()) {
            int cmd$iv = ((Number)iterator.next()).intValue();
            switch (cmd$iv) {
                case 0: {
                    double y;
                    double y$iv;
                    double x$iv = this_$iv.getData().get(n$iv++);
                    double d = y$iv = this_$iv.getData().get(n$iv++).doubleValue();
                    double x = x$iv;
                    boolean bl = false;
                    out.moveTo((float)x, (float)y);
                    break;
                }
                case 1: {
                    double y$iv;
                    double x$iv = this_$iv.getData().get(n$iv++);
                    double y = y$iv = this_$iv.getData().get(n$iv++).doubleValue();
                    double x = x$iv;
                    boolean bl = false;
                    out.lineTo((float)x, (float)y);
                    break;
                }
                case 2: {
                    double ay2;
                    void ax;
                    void cy;
                    double y2$iv;
                    double x1$iv = this_$iv.getData().get(n$iv++);
                    double y1$iv = this_$iv.getData().get(n$iv++);
                    double x2$iv = this_$iv.getData().get(n$iv++);
                    double d = y2$iv = this_$iv.getData().get(n$iv++).doubleValue();
                    double d2 = x2$iv;
                    double d3 = y1$iv;
                    double cx = x1$iv;
                    boolean bl = false;
                    out.quadTo((float)cx, (float)cy, (float)ax, (float)ay2);
                    break;
                }
                case 3: {
                    void ay;
                    void ax;
                    void cy2;
                    void cx2;
                    void cy1;
                    double y3$iv;
                    double x1$iv = this_$iv.getData().get(n$iv++);
                    double y1$iv = this_$iv.getData().get(n$iv++);
                    double x2$iv = this_$iv.getData().get(n$iv++);
                    double y2$iv = this_$iv.getData().get(n$iv++);
                    double x3$iv = this_$iv.getData().get(n$iv++);
                    double d = y3$iv = this_$iv.getData().get(n$iv++).doubleValue();
                    double d4 = x3$iv;
                    double d5 = y2$iv;
                    double d6 = x2$iv;
                    double ay2 = y1$iv;
                    double cx1 = x1$iv;
                    boolean bl = false;
                    out.cubicTo((float)cx1, (float)cy1, (float)cx2, (float)cy2, (float)ax, (float)ay);
                    break;
                }
                case 4: {
                    boolean bl = false;
                    out.close();
                }
            }
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    public final void convertPaint(@NotNull Context2d.Paint c, @NotNull Paint out) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        Context2d.Paint paint = c;
        if (paint instanceof Context2d.None) {
            out.setShader((Shader)null);
        } else if (paint instanceof Context2d.Color) {
            out.setColor(ColorFormatKt.packRGBA-Zhu_PO4(BGRA.INSTANCE, ((Context2d.Color)c).getColor()));
            out.setShader((Shader)null);
        } else if (paint instanceof Context2d.Gradient) {
            switch (AndroidContext2dRenderer$WhenMappings.$EnumSwitchMapping$1[((Context2d.Gradient)c).getKind().ordinal()]) {
                case 1: {
                    Collection<Float> collection;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    Iterable iterable = (Iterable)((Context2d.Gradient)c).getStops();
                    int[] nArray = ((Context2d.Gradient)c).getColors().toIntArray();
                    float f = (float)((Context2d.Gradient)c).getY1();
                    float f2 = (float)((Context2d.Gradient)c).getX1();
                    float f3 = (float)((Context2d.Gradient)c).getY0();
                    float f4 = (float)((Context2d.Gradient)c).getX0();
                    Paint paint2 = out;
                    void var5_18 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        void p1;
                        double d = ((Number)item$iv$iv).doubleValue();
                        collection = destination$iv$iv;
                        boolean bl = false;
                        Float f5 = Float.valueOf((float)p1);
                        collection.add(f5);
                    }
                    collection = (List)destination$iv$iv;
                    Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                    float[] fArray = CollectionsKt.toFloatArray((Collection)collection);
                    int[] nArray2 = nArray;
                    float f6 = f;
                    float f7 = f2;
                    float f8 = f3;
                    float f9 = f4;
                    paint2.setShader((Shader)new LinearGradient(f9, f8, f7, f6, nArray2, fArray, tileMode));
                    break;
                }
                case 2: {
                    Collection<Float> collection;
                    Iterable $receiver$iv = (Iterable)((Context2d.Gradient)c).getStops();
                    int[] nArray = ((Context2d.Gradient)c).getColors().toIntArray();
                    float f = (float)((Context2d.Gradient)c).getR1();
                    float f10 = (float)((Context2d.Gradient)c).getY1();
                    float f11 = (float)((Context2d.Gradient)c).getX1();
                    Paint paint3 = out;
                    Iterable $receiver$iv$iv = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        double p1 = ((Number)item$iv$iv).doubleValue();
                        collection = destination$iv$iv;
                        boolean bl = false;
                        Float f12 = Float.valueOf((float)p1);
                        collection.add(f12);
                    }
                    collection = (List)destination$iv$iv;
                    Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                    float[] fArray = CollectionsKt.toFloatArray((Collection)collection);
                    int[] nArray3 = nArray;
                    float f13 = f;
                    float f14 = f10;
                    float f15 = f11;
                    paint3.setShader((Shader)new RadialGradient(f15, f14, f13, nArray3, fArray, tileMode));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T keep(@NotNull Function0<? extends T> callback) {
        int $i$f$keep = 0;
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.getCanvas().save();
        try {
            Object object = callback.invoke();
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.getCanvas().restore();
            InlineMarker.finallyEnd((int)1);
        }
    }

    private final void setState(Context2d.State state, boolean fill) {
        com.soywiz.korma.geom.Matrix transform = state.getTransform();
        this.matrixValues[0] = (float)transform.getA();
        this.matrixValues[1] = (float)transform.getB();
        this.matrixValues[3] = (float)transform.getC();
        this.matrixValues[4] = (float)transform.getD();
        this.matrixValues[2] = (float)transform.getTx();
        this.matrixValues[5] = (float)transform.getTy();
        this.matrixValues[6] = 0.0f;
        this.matrixValues[7] = 0.0f;
        this.matrixValues[8] = 1.0f;
        this.androidMatrix.setValues(this.matrixValues);
        this.canvas.setMatrix(this.androidMatrix);
        this.paint.setStrokeWidth((float)state.getLineWidth());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(@NotNull Context2d.State state, boolean fill) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        this.setState(state, fill);
        AndroidContext2dRenderer this_$iv = this;
        boolean $i$f$keep = false;
        this_$iv.getCanvas().save();
        try {
            boolean bl = false;
            if (state.getClip() != null) {
                GraphicsPath graphicsPath = state.getClip();
                this.canvas.clipPath(graphicsPath != null ? this.toAndroid(graphicsPath) : null);
            }
            if (fill) {
                this.paint.setStyle(Paint.Style.FILL);
                this.convertPaint(state.getFillStyle(), this.paint);
            } else {
                this.paint.setStyle(Paint.Style.STROKE);
                this.convertPaint(state.getStrokeStyle(), this.paint);
            }
            this.canvas.drawPath(this.toAndroid(state.getPath()), this.paint);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.getCanvas().restore();
        }
    }

    @Override
    public void renderText(@NotNull Context2d.State state, @NotNull Context2d.Font font2, @NotNull String text, double x, double y, boolean fill) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)font2, (String)"font");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Context2d.TextMetrics metrics = new Context2d.TextMetrics(null, 1, null);
        Rectangle bounds = metrics.getBounds();
        this.paint.setTypeface(Typeface.create((String)font2.getName(), (int)0));
        this.paint.setTextSize((float)font2.getSize());
        Paint.FontMetrics fm = this.paint.getFontMetrics();
        this.getBounds(font2, text, metrics);
        float baseline = fm.ascent + fm.descent;
        double ox = state.getHorizontalAlign().getOffsetX(bounds.getWidth());
        double oy = state.getVerticalAlign().getOffsetY(bounds.getHeight(), baseline);
        this.canvas.drawText(text, 0, text.length(), (float)(x - ox), (float)(y + (double)baseline - oy), this.paint);
    }

    @Override
    public void getBounds(@NotNull Context2d.Font font2, @NotNull String text, @NotNull Context2d.TextMetrics out) {
        Intrinsics.checkParameterIsNotNull((Object)font2, (String)"font");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        Rect rect = new Rect();
        this.paint.getTextBounds(text, 0, text.length(), rect);
        out.getBounds().setTo((double)rect.left, (double)rect.top, (double)rect.width(), (double)rect.height());
    }

    @NotNull
    public final Bitmap getBmp() {
        return this.bmp;
    }

    public AndroidContext2dRenderer(@NotNull Bitmap bmp2) {
        Paint paint;
        Intrinsics.checkParameterIsNotNull((Object)bmp2, (String)"bmp");
        this.bmp = bmp2;
        Paint paint2 = new Paint(135);
        AndroidContext2dRenderer androidContext2dRenderer = this;
        Paint $receiver = paint2;
        boolean bl = false;
        $receiver.setHinting(1);
        $receiver.setAntiAlias(true);
        $receiver.setFilterBitmap(true);
        $receiver.setDither(true);
        androidContext2dRenderer.paint = paint = paint2;
        this.canvas = new Canvas(this.bmp);
        this.matrixValues = new float[9];
        this.androidMatrix = new Matrix();
    }
}

