/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.korim.format;

import com.soywiz.korim.bitmap.Bitmap32;
import com.soywiz.korim.bitmap.Bitmap8;
import com.soywiz.korim.color.BGR;
import com.soywiz.korim.color.ColorFormat;
import com.soywiz.korim.color.RGBA;
import com.soywiz.korim.format.ImageData;
import com.soywiz.korim.format.ImageDecodingProps;
import com.soywiz.korim.format.ImageFormat;
import com.soywiz.korim.format.ImageFrame;
import com.soywiz.korim.format.ImageInfo;
import com.soywiz.korio.stream.SyncInputStream;
import com.soywiz.korio.stream.SyncStream;
import com.soywiz.korio.stream.SyncStreamKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/soywiz/korim/format/BMP;", "Lcom/soywiz/korim/format/ImageFormat;", "()V", "decodeHeader", "Lcom/soywiz/korim/format/ImageInfo;", "s", "Lcom/soywiz/korio/stream/SyncStream;", "props", "Lcom/soywiz/korim/format/ImageDecodingProps;", "readImage", "Lcom/soywiz/korim/format/ImageData;", "korim_release"})
public final class BMP
extends ImageFormat {
    public static final BMP INSTANCE;

    @Override
    @Nullable
    public ImageInfo decodeHeader(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        ImageInfo imageInfo;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull((Object)props, (String)"props");
        if (Intrinsics.areEqual((Object)SyncStreamKt.readStringz$default((SyncInputStream)((SyncInputStream)s), (int)2, null, (int)2, null), (Object)"BM") ^ true) {
            return null;
        }
        int size = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int reserved1 = SyncStreamKt.readS16LE((SyncInputStream)((SyncInputStream)s));
        int reserved2 = SyncStreamKt.readS16LE((SyncInputStream)((SyncInputStream)s));
        int offBits = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int bsize = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int width = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int height = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int planes = SyncStreamKt.readS16LE((SyncInputStream)((SyncInputStream)s));
        int bitcount = SyncStreamKt.readS16LE((SyncInputStream)((SyncInputStream)s));
        ImageInfo $receiver = imageInfo = new ImageInfo();
        boolean bl = false;
        $receiver.setWidth(width);
        $receiver.setHeight(height);
        $receiver.setBitsPerPixel(bitcount);
        return imageInfo;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ImageData readImage(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        ImageData imageData;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull((Object)props, (String)"props");
        ImageInfo imageInfo = this.decodeHeader(s, props);
        if (imageInfo == null) {
            throw (Throwable)new IllegalArgumentException("Not a BMP file");
        }
        ImageInfo h = imageInfo;
        int compression = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int sizeImage = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int pixelsPerMeterX = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int pixelsPerMeterY = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int clrUsed = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int clrImportant = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        switch (h.getBitsPerPixel()) {
            case 8: {
                int n;
                Bitmap8 out = new Bitmap8(h.getWidth(), h.getHeight(), null, null, 12, null);
                int n2 = 0;
                int n3 = 256;
                while (n2 < n3) {
                    out.getPalette()[n] = RGBA.Companion.packFast(SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s)), 255);
                    ++n;
                }
                n3 = h.getHeight();
                for (n = 0; n < n3; ++n) {
                    out.setRow(h.getHeight() - n - 1, SyncStreamKt.readBytes((SyncInputStream)((SyncInputStream)s), (int)h.getWidth()));
                }
                imageData = new ImageData(CollectionsKt.listOf((Object)new ImageFrame(out, 0L, 0, 0, false, 30, null)));
                break;
            }
            case 24: 
            case 32: {
                int bytesPerRow = h.getWidth() * h.getBitsPerPixel() / 8;
                Bitmap32 out = new Bitmap32(h.getWidth(), h.getHeight(), null, false, 12, null);
                byte[] row = new byte[bytesPerRow];
                ColorFormat format = h.getBitsPerPixel() == 24 ? (ColorFormat)BGR.INSTANCE : (ColorFormat)RGBA.Companion;
                int padding = 4 - bytesPerRow % 4;
                int n = 0;
                int n4 = h.getHeight();
                while (n < n4) {
                    void n5;
                    int y = h.getHeight() - n5 - 1;
                    SyncInputStream.DefaultImpls.read$default((SyncInputStream)s, (byte[])row, (int)0, (int)0, (int)6, null);
                    ColorFormat.decode--FRkKZs$default(format, row, 0, out.getData(), out.index(0, y), h.getWidth(), false, 32, null);
                    if (padding != 0) {
                        SyncStreamKt.skip((SyncStream)s, (int)padding);
                    }
                    ++n5;
                }
                imageData = new ImageData(CollectionsKt.listOf((Object)new ImageFrame(out, 0L, 0, 0, false, 30, null)));
                break;
            }
            default: {
                String string = "Unsupported bitsPerPixel=" + h.getBitsPerPixel();
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        return imageData;
    }

    private BMP() {
        super("bmp");
    }

    static {
        BMP bMP;
        INSTANCE = bMP = new BMP();
    }
}

