/*
 * Decompiled with CFR 0.152.
 */
package com.soywiz.korim.format;

import com.soywiz.korim.bitmap.Bitmap32;
import com.soywiz.korim.bitmap.Bitmap8;
import com.soywiz.korim.color.BGR;
import com.soywiz.korim.color.BGRA;
import com.soywiz.korim.color.ColorFormat;
import com.soywiz.korim.color.ColorFormatKt;
import com.soywiz.korim.color.RGBA;
import com.soywiz.korim.color.RgbaArray;
import com.soywiz.korim.format.ImageData;
import com.soywiz.korim.format.ImageDecodingProps;
import com.soywiz.korim.format.ImageEncodingProps;
import com.soywiz.korim.format.ImageFormat;
import com.soywiz.korim.format.ImageFrame;
import com.soywiz.korim.format.ImageInfo;
import com.soywiz.korio.stream.SyncInputStream;
import com.soywiz.korio.stream.SyncOutputStream;
import com.soywiz.korio.stream.SyncStream;
import com.soywiz.korio.stream.SyncStreamKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/soywiz/korim/format/BMP;", "Lcom/soywiz/korim/format/ImageFormat;", "()V", "decodeHeader", "Lcom/soywiz/korim/format/BMP$BmImageInfo;", "s", "Lcom/soywiz/korio/stream/SyncStream;", "props", "Lcom/soywiz/korim/format/ImageDecodingProps;", "readImage", "Lcom/soywiz/korim/format/ImageData;", "writeImage", "", "image", "Lcom/soywiz/korim/format/ImageEncodingProps;", "BmImageInfo", "korim_debug"})
public final class BMP
extends ImageFormat {
    public static final BMP INSTANCE;

    @Override
    @Nullable
    public BmImageInfo decodeHeader(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        BmImageInfo bmImageInfo;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull((Object)props, (String)"props");
        if (Intrinsics.areEqual((Object)SyncStreamKt.readStringz$default((SyncInputStream)((SyncInputStream)s), (int)2, null, (int)2, null), (Object)"BM") ^ true) {
            return null;
        }
        int size = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int reserved1 = SyncStreamKt.readS16LE((SyncInputStream)((SyncInputStream)s));
        int reserved2 = SyncStreamKt.readS16LE((SyncInputStream)((SyncInputStream)s));
        int offBits = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int bsize = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int width = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int height = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int planes = SyncStreamKt.readS16LE((SyncInputStream)((SyncInputStream)s));
        int bitcount = SyncStreamKt.readS16LE((SyncInputStream)((SyncInputStream)s));
        BmImageInfo $receiver = bmImageInfo = new BmImageInfo();
        boolean bl = false;
        $receiver.setFlipX(width < 0);
        $receiver.setFlipY(height >= 0);
        int n = width;
        BmImageInfo bmImageInfo2 = $receiver;
        int n2 = Math.abs(n);
        bmImageInfo2.setWidth(n2);
        n = height;
        bmImageInfo2 = $receiver;
        n2 = Math.abs(n);
        bmImageInfo2.setHeight(n2);
        $receiver.setBitsPerPixel(bitcount);
        return bmImageInfo;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ImageData readImage(@NotNull SyncStream s, @NotNull ImageDecodingProps props) {
        ImageData imageData;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull((Object)props, (String)"props");
        BmImageInfo bmImageInfo = this.decodeHeader(s, props);
        if (bmImageInfo == null) {
            throw (Throwable)new IllegalArgumentException("Not a BMP file");
        }
        BmImageInfo h = bmImageInfo;
        int compression = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int sizeImage = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int pixelsPerMeterX = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int pixelsPerMeterY = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int clrUsed = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        int clrImportant = SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s));
        switch (h.getBitsPerPixel()) {
            case 8: {
                int n;
                Bitmap8 out = new Bitmap8(h.getWidth(), h.getHeight(), null, null, 12, null);
                int n2 = 0;
                int n3 = 256;
                while (n2 < n3) {
                    RgbaArray.set-WjRQ3Gs(out.getPalette(), n, RGBA.Companion.invoke(SyncStreamKt.readS32LE((SyncInputStream)((SyncInputStream)s)), 255));
                    ++n;
                }
                n3 = h.getHeight();
                for (n = 0; n < n3; ++n) {
                    out.setRow(h.getHeight() - n - 1, SyncStreamKt.readBytes((SyncInputStream)((SyncInputStream)s), (int)h.getWidth()));
                }
                imageData = new ImageData(CollectionsKt.listOf((Object)new ImageFrame(out, 0L, 0, 0, false, 30, null)));
                break;
            }
            case 24: 
            case 32: {
                int bytesPerRow = h.getWidth() * h.getBitsPerPixel() / 8;
                Bitmap32 out = new Bitmap32(h.getWidth(), h.getHeight(), null, false, 12, null);
                byte[] row = new byte[bytesPerRow];
                ColorFormat format = h.getBitsPerPixel() == 24 ? (ColorFormat)BGR.INSTANCE : (ColorFormat)BGRA.INSTANCE;
                int padding = 4 - bytesPerRow % 4;
                boolean flipY = h.getFlipY();
                int n = 0;
                int n4 = h.getHeight();
                while (n < n4) {
                    void n5;
                    void y = h.getFlipY() ? h.getHeight() - n5 - 1 : n5;
                    SyncInputStream.DefaultImpls.read$default((SyncInputStream)s, (byte[])row, (int)0, (int)0, (int)6, null);
                    ColorFormatKt.decode-by-m-to$default(format, row, 0, out.getData(), out.index(0, (int)y), h.getWidth(), false, 32, null);
                    if (padding != 0) {
                        SyncStreamKt.skip((SyncStream)s, (int)padding);
                    }
                    ++n5;
                }
                imageData = new ImageData(CollectionsKt.listOf((Object)new ImageFrame(out, 0L, 0, 0, false, 30, null)));
                break;
            }
            default: {
                String string = "Unsupported bitsPerPixel=" + h.getBitsPerPixel();
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        return imageData;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeImage(@NotNull ImageData image, @NotNull SyncStream s, @NotNull ImageEncodingProps props) {
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        Intrinsics.checkParameterIsNotNull((Object)props, (String)"props");
        Bitmap32 bmp2 = image.getMainBitmap().toBMP32();
        SyncStreamKt.write8((SyncOutputStream)((SyncOutputStream)s), (int)66);
        SyncStreamKt.write8((SyncOutputStream)((SyncOutputStream)s), (int)77);
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)s), (int)(4 * bmp2.getArea()));
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)s), (int)0);
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)s), (int)54);
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)s), (int)40);
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)s), (int)bmp2.getWidth());
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)s), (int)(bmp2.getHeight() * 2));
        SyncStreamKt.write16LE((SyncOutputStream)((SyncOutputStream)s), (int)1);
        SyncStreamKt.write16LE((SyncOutputStream)((SyncOutputStream)s), (int)32);
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)s), (int)0);
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)s), (int)(4 * bmp2.getArea()));
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)s), (int)2834);
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)s), (int)2834);
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)s), (int)0);
        SyncStreamKt.write32LE((SyncOutputStream)((SyncOutputStream)s), (int)0);
        int n = 0;
        int n2 = bmp2.getHeight();
        while (n < n2) {
            void n3;
            int y = bmp2.getHeight() - 1 - n3;
            SyncStreamKt.writeBytes((SyncOutputStream)((SyncOutputStream)s), (byte[])ColorFormatKt.encode-ZizfYWE(BGRA.INSTANCE, bmp2.getData(), y * bmp2.getWidth(), bmp2.getWidth(), true));
            ++n3;
        }
    }

    private BMP() {
        super("bmp");
    }

    static {
        BMP bMP;
        INSTANCE = bMP = new BMP();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lcom/soywiz/korim/format/BMP$BmImageInfo;", "Lcom/soywiz/korim/format/ImageInfo;", "()V", "flipX", "", "getFlipX", "()Z", "setFlipX", "(Z)V", "flipY", "getFlipY", "setFlipY", "korim_debug"})
    public static final class BmImageInfo
    extends ImageInfo {
        private boolean flipX;
        private boolean flipY;

        public final boolean getFlipX() {
            return this.flipX;
        }

        public final void setFlipX(boolean bl) {
            this.flipX = bl;
        }

        public final boolean getFlipY() {
            return this.flipY;
        }

        public final void setFlipY(boolean bl) {
            this.flipY = bl;
        }
    }
}

